/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.core.customreports.chart;

import edu.mit.broad.core.customreports.ReportDomain;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Transient;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.util.TableOrder;

@Entity
public class CustomReportChartDef {
    private Long chartDefinitionId;
    private String name;
    private String description;
    private Long fullCustomReportId;
    private Long summaryCustomReportId;
    private Long chartWidth;
    private Long chartHeight;
    private ChartType chartType;
    private String rangeAxisLabel;
    private String plotOrientation;
    private Boolean legend;
    private String tableOrder;
    private ReportDomain domain;
    private Integer binNumber;
    private Boolean overlayStatus;
    private Date lastUpdatedOn;
    private Date createdOn;
    private String updatedBy;
    private String createdBy;

    @Id
    @GeneratedValue(generator="GenChartRep")
    @GenericGenerator(name="GenChartRep", strategy="sequence", parameters={@Parameter(name="sequence", value="SQ_CUSTOM_REPORT_CHART_DEF")})
    @Column(name="CHART_DEFINITION_ID")
    public Long getChartDefinitionId() {
        return this.chartDefinitionId;
    }

    public void setChartDefinitionId(Long chartDefinitionId) {
        this.chartDefinitionId = chartDefinitionId;
    }

    @Column(name="NAME")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="FULL_CUSTOM_REPORT_ID")
    public Long getFullCustomReportId() {
        return this.fullCustomReportId;
    }

    public void setFullCustomReportId(Long fullCustomReportId) {
        this.fullCustomReportId = fullCustomReportId;
    }

    @Column(name="SUMMARY_CUSTOM_REPORT_ID")
    public Long getSummaryCustomReportId() {
        return this.summaryCustomReportId;
    }

    public void setSummaryCustomReportId(Long summaryCustomReportId) {
        this.summaryCustomReportId = summaryCustomReportId;
    }

    @Column(name="CHART_HEIGHT")
    public Long getChartHeight() {
        return this.chartHeight;
    }

    public void setChartHeight(Long chartHeight) {
        this.chartHeight = chartHeight;
    }

    @Column(name="CHART_WIDTH")
    public Long getChartWidth() {
        return this.chartWidth;
    }

    public void setChartWidth(Long chartWidth) {
        this.chartWidth = chartWidth;
    }

    @Column(name="DESCRIPTION")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="CHART_TYPE")
    public ChartType getChartType() {
        return this.chartType;
    }

    public void setChartType(ChartType chartType) {
        this.chartType = chartType;
    }

    @Column(name="BIN_NUMBER")
    public Integer getBinNumber() {
        return this.binNumber;
    }

    public void setBinNumber(Integer binNumber) {
        this.binNumber = binNumber;
    }

    @Column(name="OVERLAY_STATUS")
    public Boolean getOverlayStatus() {
        return this.overlayStatus == null || this.overlayStatus != false;
    }

    public void setOverlayStatus(Boolean overlayStatus) {
        this.overlayStatus = overlayStatus;
    }

    @Column(name="CREATED_BY")
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @Column(name="CREATED_ON")
    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    @Column(name="LAST_UPDATED_ON")
    public Date getLastUpdatedOn() {
        return this.lastUpdatedOn;
    }

    public void setLastUpdatedOn(Date lastUpdatedOn) {
        this.lastUpdatedOn = lastUpdatedOn;
    }

    @Column(name="UPDATED_BY")
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    @Column(name="LEGEND", nullable=false)
    public Boolean getLegend() {
        return this.legend;
    }

    public void setLegend(Boolean legend) {
        this.legend = legend;
    }

    @Transient
    public Boolean isLegend() {
        return this.getLegend();
    }

    @Column(name="RANGE_AXIS_LABEL")
    public String getRangeAxisLabel() {
        return this.rangeAxisLabel;
    }

    public void setRangeAxisLabel(String rangeAxisLabel) {
        this.rangeAxisLabel = rangeAxisLabel;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="DOMAIN")
    public ReportDomain getDomain() {
        return this.domain;
    }

    public void setDomain(ReportDomain domain) {
        this.domain = domain;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="PLOT_ORIENTATION")
    protected String getPlotOrientation() {
        return this.plotOrientation;
    }

    public void setPlotOrientation(String plotOrientation) {
        this.plotOrientation = plotOrientation;
    }

    @Transient
    public PlotOrientation getRealPlotOrientation() {
        if (PlotOrientation.VERTICAL.toString().equals(this.getPlotOrientation())) {
            return PlotOrientation.VERTICAL;
        }
        return PlotOrientation.HORIZONTAL;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="TABLE_ORDER")
    protected String getTableOrder() {
        return this.tableOrder;
    }

    public void setTableOrder(String tableOrder) {
        this.tableOrder = tableOrder;
    }

    @Transient
    public TableOrder getRealTableOrder() {
        if (TableOrder.BY_COLUMN.toString().equals(this.getTableOrder())) {
            return TableOrder.BY_COLUMN;
        }
        return TableOrder.BY_ROW;
    }

    public int compareTo(Object otherChartDef) throws ClassCastException {
        return this.getChartDefinitionId().compareTo(((CustomReportChartDef)otherChartDef).getChartDefinitionId());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomReportChartDef other = (CustomReportChartDef)obj;
        return !(this.chartDefinitionId == null ? other.chartDefinitionId != null : !this.chartDefinitionId.equals(other.chartDefinitionId));
    }

    public static enum ChartType {
        BAR,
        HISTOGRAM,
        LINE,
        AREA,
        BAR_3D,
        LINE_3D,
        MULTIPLE_PIE,
        MULTIPLE_PIE_3D,
        STACKED_AREA,
        STACKED_BAR,
        STACKED_BAR_3D,
        WATERFALL;

    }
}

