/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.core.customreports;

import edu.mit.broad.core.customreports.ReportRenderer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;

public class TabSeparatedReportRenderer
implements ReportRenderer {
    private Writer writer;
    private static char SEPARATOR_CHAR = (char)9;
    private boolean firstColumn = true;
    private DateFormat df = DateFormat.getDateInstance(2);

    public TabSeparatedReportRenderer(OutputStream writer) {
        this.writer = new OutputStreamWriter(writer);
    }

    @Override
    public ReportRenderer nextCell(Date contents) throws IOException {
        String s = contents != null ? this.df.format(contents) : null;
        return this.nextCell(s);
    }

    @Override
    public ReportRenderer nextCell(String ... contents) throws IOException {
        for (String s : contents) {
            this.renderSeparator();
            if (s == null) continue;
            this.writer.write(s);
        }
        return this;
    }

    @Override
    public ReportRenderer nextRow() throws IOException {
        this.writer.write("\n");
        this.firstColumn = true;
        return this;
    }

    private void renderSeparator() throws IOException {
        if (this.firstColumn) {
            this.firstColumn = false;
        } else {
            this.writer.write(SEPARATOR_CHAR);
        }
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }
}

