/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.core.customreports;

import edu.mit.broad.core.customreports.ReportRenderer;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;

public class HtmlTableReportRenderer
implements ReportRenderer {
    Writer writer;
    private static String START_ROW = "<tr $ID$>";
    private boolean firstColumn = true;
    private DateFormat df = DateFormat.getDateInstance(2);
    private int currentRow = 0;

    public HtmlTableReportRenderer(Writer writer) {
        this.writer = writer;
    }

    @Override
    public ReportRenderer nextCell(Date contents) throws IOException {
        String s = contents != null ? this.df.format(contents) : null;
        return this.nextCell(s);
    }

    @Override
    public ReportRenderer nextCell(String ... contents) throws IOException {
        this.renderSeparator();
        if (contents != null) {
            this.writer.write("<td>");
            for (String s : contents) {
                this.writer.write(s == null ? "" : s);
            }
            this.writer.write("</td>");
        } else {
            this.writer.write("<td>&nbsp;</td>");
        }
        return this;
    }

    @Override
    public ReportRenderer nextRow() throws IOException {
        this.writer.write("</tr>");
        this.firstColumn = true;
        return this;
    }

    private void renderSeparator() throws IOException {
        if (this.firstColumn) {
            this.firstColumn = false;
            this.writer.write(START_ROW.replace("$ID$", "id=" + (this.currentRow % 2 == 0 ? "odd" : "even")));
            ++this.currentRow;
        }
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }
}

