/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.core.customreports;

import edu.mit.broad.core.BroadCoreException;
import edu.mit.broad.core.customreports.ReportRenderer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class ExcelReportRenderer
implements ReportRenderer {
    private static final int EXCEL_MAX_ROWS = 65500;
    private HSSFWorkbook wb;
    private HSSFSheet sheet;
    private short currentRow = 0;
    private short currentCell = 0;
    private HSSFRow row = null;
    private HSSFCellStyle dateStyle;
    private HSSFCellStyle linkStyle;
    private OutputStream out;

    public ExcelReportRenderer(OutputStream out) {
        this.out = out;
        this.wb = new HSSFWorkbook();
        this.sheet = this.wb.createSheet("Sheet1");
        this.row = this.sheet.createRow((int)this.currentRow);
        this.dateStyle = this.wb.createCellStyle();
        this.dateStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"m/d/yy h:mm"));
        HSSFFont linkFont = this.wb.createFont();
        linkFont.setUnderline((byte)1);
        linkFont.setColor((short)12);
        this.linkStyle = this.wb.createCellStyle();
        this.linkStyle.setFont(linkFont);
    }

    @Override
    public void flush() throws IOException {
        this.wb.write(this.out);
        this.out.flush();
    }

    @Override
    public ReportRenderer nextCell(Date contents) {
        short s = this.currentCell;
        this.currentCell = (short)(s + 1);
        HSSFCell cell = this.row.createCell(s);
        cell.setCellValue(contents);
        cell.setCellStyle(this.dateStyle);
        return this;
    }

    @Override
    public ReportRenderer nextCell(String ... contents) {
        if (contents != null) {
            for (String s : contents) {
                short s2 = this.currentCell;
                this.currentCell = (short)(s2 + 1);
                HSSFCell cell = this.row.createCell(s2);
                if (s != null && s.startsWith("=HYPERLINK")) {
                    cell.setCellType(2);
                    cell.setCellFormula(s.substring(1));
                    cell.setCellStyle(this.linkStyle);
                    continue;
                }
                cell.setCellValue(s);
            }
        }
        return this;
    }

    @Override
    public ReportRenderer nextRow() {
        this.currentRow = (short)(this.currentRow + 1);
        this.row = this.sheet.createRow((int)this.currentRow);
        this.currentCell = 0;
        if (this.currentRow > 65500) {
            throw new BroadCoreException("Attempted to render an Excel-based report with more than 65500 rows!");
        }
        return this;
    }

    public HSSFSheet getSheet() {
        return this.sheet;
    }
}

