/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.core.customreports;

import edu.mit.broad.core.BroadCoreException;
import edu.mit.broad.core.common.ParameterType;
import edu.mit.broad.core.customreports.CustomReport;
import edu.mit.broad.core.util.ReflectionUtils;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
public class CustomReportParameter
implements ParameterType {
    private Long parameterId;
    private Long idx;
    private CustomReport report;
    private String name;
    private String prompt;
    private String typeClass;
    private transient Class type;

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="GenCustRepPar")
    @GenericGenerator(name="GenCustRepPar", strategy="sequence", parameters={@Parameter(name="sequence", value="sq_custom_report_param")})
    public Long getParameterId() {
        return this.parameterId;
    }

    public void setParameterId(Long parameterId) {
        this.parameterId = parameterId;
    }

    @ManyToOne
    @JoinColumn(name="report_id", insertable=false, updatable=false)
    public CustomReport getReport() {
        return this.report;
    }

    public void setReport(CustomReport report) {
        this.report = report;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    @Column(name="typeclass")
    public String getTypeClass() {
        return this.typeClass;
    }

    public void setTypeClass(String typeClass) {
        this.typeClass = typeClass;
    }

    public Long getIdx() {
        return this.idx;
    }

    public void setIdx(Long idx) {
        this.idx = idx;
    }

    @Override
    @Transient
    public Class getType() {
        if (this.type == null) {
            try {
                this.type = ReflectionUtils.asClass(this.getTypeClass());
            }
            catch (ClassNotFoundException cnfe) {
                throw new BroadCoreException("Invalid parameter class: " + this.getTypeClass(), cnfe);
            }
        }
        return this.type;
    }

    @Override
    @Transient
    public String getDescription() {
        return this.getPrompt();
    }
}

