/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.core.customreports;

import edu.mit.broad.core.BroadCoreException;
import edu.mit.broad.core.customreports.CategoryComparator;
import edu.mit.broad.core.customreports.CustomReport;
import edu.mit.broad.core.customreports.CustomReportCategory;
import edu.mit.broad.core.customreports.CustomReportDAO;
import edu.mit.broad.core.customreports.CustomReportParameter;
import edu.mit.broad.core.customreports.CustomReportRole;
import edu.mit.broad.core.customreports.ReportComparator;
import edu.mit.broad.core.customreports.ReportDomain;
import edu.mit.broad.core.customreports.ReportRenderer;
import edu.mit.broad.core.customreports.RoleComparator;
import edu.mit.broad.core.util.DbUtils;
import edu.mit.broad.core.util.ExpressionUtil;
import edu.mit.broad.core.util.JndiUtil;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sql.TIMESTAMP;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.RowSetDynaClass;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CustomReportManager {
    private static Log log = LogFactory.getLog(CustomReportManager.class);
    CustomReportDAO dao = new CustomReportDAO();
    private static final Pattern bindParams = Pattern.compile(":([\\w\\.]+)\\b");
    private static String validateSelectSQLProcString = "DECLARE\n  sqlStr varchar2(30000) := ? ;\n  c INTEGER := null;\nBEGIN\n  IF sqlStr IS NULL OR NOT REGEXP_LIKE(sqlStr, '^[[:space:]]*select', 'i') THEN\n\tRAISE_APPLICATION_ERROR(-20101, 'SQL is either null or not a SELECT statement');\n  END IF;\n  c := DBMS_SQL.OPEN_CURSOR;\n  DBMS_SQL.PARSE(c, sqlStr, DBMS_SQL.V7);\n  DBMS_SQL.CLOSE_CURSOR(c);\nEXCEPTION\n  WHEN OTHERS THEN\n    IF c IS NOT NULL THEN\n    \tDBMS_SQL.CLOSE_CURSOR(c);\n    END IF;\n    RAISE;\nEND;";

    public CustomReport getReportById(Long customReportId) {
        return (CustomReport)this.dao.get(customReportId);
    }

    public CustomReport getFullReportById(Long customReportId) throws Exception {
        return this.dao.getHydratedReport(customReportId);
    }

    public CustomReport merge(CustomReport report) {
        return this.dao.merge(report);
    }

    public void delete(CustomReport report) {
        this.dao.delete(report);
    }

    public void deleteParameter(CustomReportParameter parameter) {
        this.dao.delete(parameter);
    }

    public void save(CustomReport report) {
        this.dao.save(report);
    }

    public List<CustomReportCategory> getReportCategoriesByNames(SortedSet<String> categoryNames) {
        return this.dao.getReportCategoriesByNames(categoryNames);
    }

    public SortedSet<CustomReport> getReports(Long groupId, Long projectId, Long experimentId, Collection<ReportDomain> domains) {
        List<CustomReport> reportList = this.dao.getReports(groupId, projectId, experimentId, domains);
        TreeSet<CustomReport> reportSet = new TreeSet<CustomReport>(new ReportComparator());
        reportSet.addAll(reportList);
        return reportSet;
    }

    public Collection<CustomReport> getReports(Long groupId, Long projectId, Long experimentId, List<ReportDomain> domains, List<String> roles, List<String> categories) {
        List<CustomReport> reportList = this.dao.getReports(groupId, projectId, experimentId, domains, roles, categories);
        TreeSet<CustomReport> reportSet = new TreeSet<CustomReport>(new ReportComparator());
        reportSet.addAll(reportList);
        return reportSet;
    }

    public static String getURL(long reportId, Map<String, String> parameters, String format, String filename) {
        StringBuilder sb = new StringBuilder();
        sb.append("/CustomReport.action?executeReport&report.reportId=");
        sb.append(reportId);
        sb.append("&directDownloadFormat=");
        sb.append(format);
        sb.append("&overrideFilename=");
        sb.append(filename);
        for (String key : parameters.keySet()) {
            sb.append("&variables['");
            sb.append(key);
            sb.append("']=");
            sb.append(parameters.get(key));
        }
        return sb.toString();
    }

    public List<String> getDataSourceList() {
        try {
            return JndiUtil.list("java:ds");
        }
        catch (BroadCoreException e) {
            return JndiUtil.list("java:comp/env/ds");
        }
    }

    public RowSetDynaClass executeReport(long reportId, Map<String, Object> variables, String fullName) {
        GAPRowSetDynaClass gAPRowSetDynaClass;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            CustomReport report = (CustomReport)this.dao.get(reportId);
            conn = this.getConnnection(report);
            ps = this.prepareStatement(report, conn, variables);
            rs = ps.executeQuery();
            this.updateRunStats(report, fullName);
            gAPRowSetDynaClass = new GAPRowSetDynaClass(rs, false);
        }
        catch (Exception e) {
            try {
                throw new BroadCoreException("Exception while executing custom report.", e);
            }
            catch (Throwable throwable) {
                DbUtils.close(rs, ps, conn);
                throw throwable;
            }
        }
        DbUtils.close(rs, ps, conn);
        return gAPRowSetDynaClass;
    }

    private void updateRunStats(CustomReport report, String fullName) {
        if (fullName != null) {
            Long runCount = report.getRunCount();
            if (runCount == null) {
                runCount = 0L;
            }
            Long l = runCount;
            Long l2 = runCount = Long.valueOf(runCount + 1L);
            report.setRunCount(runCount);
            report.setLastRunDate(new Date());
            report.setLastRunBy(fullName);
        }
    }

    public void writeResults(long reportId, Map<String, Object> variables, ReportRenderer renderer, String fullName) {
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            int i;
            CustomReport report = (CustomReport)this.dao.get(reportId);
            conn = this.getConnnection(report);
            ps = this.prepareStatement(report, conn, variables);
            rs = ps.executeQuery();
            this.updateRunStats(report, fullName);
            int numCols = rs.getMetaData().getColumnCount();
            for (i = 1; i <= numCols; ++i) {
                renderer.nextCell(rs.getMetaData().getColumnName(i).replace("_", " "));
            }
            renderer.nextRow();
            while (rs.next()) {
                for (i = 1; i <= numCols; ++i) {
                    if (TIMESTAMP.class.getName().equals(rs.getMetaData().getColumnClassName(i))) {
                        renderer.nextCell(rs.getDate(i));
                        continue;
                    }
                    renderer.nextCell(rs.getString(i));
                }
                renderer.nextRow();
            }
            renderer.flush();
        }
        catch (Exception se) {
            try {
                throw new BroadCoreException("Exception while executing custom report.", se);
            }
            catch (Throwable throwable) {
                DbUtils.close(rs, ps, conn);
                throw throwable;
            }
        }
        DbUtils.close(rs, ps, conn);
    }

    private Connection getConnnection(CustomReport report) throws SQLException {
        DataSource ds = (DataSource)JndiUtil.lookup(report.getDataSourceName());
        return ds.getConnection();
    }

    PreparedStatement prepareStatement(CustomReport report, Connection conn, Map<String, Object> variables) {
        ExpressionUtil exprUtil = new ExpressionUtil();
        try {
            String sql = exprUtil.evaluate(report.getData(), variables);
            log.trace((Object)("Executing SQL:" + sql));
            String cleanSQL = this.cleanSQL(sql);
            OracleConnection oracleConnection = DbUtils.getOracleConnection(conn);
            OraclePreparedStatement ops = (OraclePreparedStatement)oracleConnection.prepareStatement(cleanSQL);
            Matcher m = bindParams.matcher(report.getData());
            while (m.find()) {
                String name = m.group(1);
                Object o = exprUtil.evaluate(name, variables, Object.class);
                String cleanName = name.replace(".", "_");
                log.trace((Object)("Binding parameter:'" + cleanName + "' to value '" + (o == null ? "NULL" : o.toString()) + "'"));
                CustomReportParameter p = report.getParameter(name);
                Class type = null;
                if (p != null) {
                    type = p.getType();
                }
                DbUtils.bindParameter(ops, type, cleanName, o);
            }
            return ops;
        }
        catch (Exception e) {
            throw new BroadCoreException("Exception preparing statement for custom report.", e);
        }
    }

    private String cleanSQL(String sql) {
        Matcher m = bindParams.matcher(sql);
        String cleanSQL = sql;
        while (m.find()) {
            String name = m.group(1);
            String cleanName = name.replace(".", "_");
            cleanSQL = cleanSQL.replace(name, cleanName);
        }
        return cleanSQL;
    }

    public CustomReport setCategories(long reportId, SortedSet<String> updatedCategoryList) {
        List<CustomReportCategory> categories = this.dao.getReportCategories(reportId);
        if (categories != null) {
            for (CustomReportCategory category : categories) {
                this.dao.delete(category);
            }
        }
        CustomReport newReport = (CustomReport)this.dao.get(reportId);
        newReport.setCategories(this.createCategoryList(reportId, updatedCategoryList));
        return newReport;
    }

    public CustomReport setRoles(long reportId, SortedSet<String> updatedRoleList) {
        List<CustomReportRole> roles = this.dao.getReportRoles(reportId);
        if (roles != null) {
            for (CustomReportRole role : roles) {
                this.dao.delete(role);
            }
        }
        CustomReport newReport = (CustomReport)this.dao.get(reportId);
        newReport.setRoles(this.createRoleList(reportId, updatedRoleList));
        return newReport;
    }

    private SortedSet<CustomReportCategory> createCategoryList(Long reportId, SortedSet<String> categoryNames) {
        TreeSet<CustomReportCategory> categorySet = new TreeSet<CustomReportCategory>(new CategoryComparator());
        for (String categoryName : categoryNames) {
            CustomReportCategory category = new CustomReportCategory();
            category.setName(categoryName);
            category.setReportId(reportId);
            categorySet.add(category);
        }
        return categorySet;
    }

    private SortedSet<CustomReportRole> createRoleList(long reportId, SortedSet<String> roleNames) {
        TreeSet<CustomReportRole> roleSet = new TreeSet<CustomReportRole>(new RoleComparator());
        for (String roleName : roleNames) {
            CustomReportRole role = new CustomReportRole();
            role.setRoleName(roleName);
            role.setReportId(reportId);
            roleSet.add(role);
        }
        return roleSet;
    }

    public void validateCustomReport(CustomReport r, Map<String, Object> variables) {
        ExpressionUtil exprUtil = new ExpressionUtil();
        Connection conn = null;
        try {
            conn = this.getConnnection(r);
            String sql = exprUtil.evaluate(r.getData(), variables);
            String cleanSQL = this.cleanSQL(sql);
            this.validateSelectSQL(conn, cleanSQL);
            this.checkParamType(r);
        }
        catch (Exception e) {
            throw new BroadCoreException("Exception validating custom report.", e);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean validateSelectSQL(Connection conn, String sqlString) throws SQLException {
        CallableStatement cs = null;
        try {
            cs = conn.prepareCall(validateSelectSQLProcString);
            cs.setString(1, sqlString);
            cs.execute();
        }
        finally {
            try {
                if (cs != null) {
                    cs.close();
                }
            }
            catch (Exception e) {}
        }
        return true;
    }

    public void checkParamType(CustomReport r) {
        if (r == null || r.getParameters() == null || r.getParameters().size() == 0) {
            return;
        }
        for (CustomReportParameter p : r.getParameters()) {
            try {
                p.getType();
            }
            catch (Exception e) {
                throw new BroadCoreException("ERROR: bad parameter type class: " + p.getTypeClass(), e);
            }
        }
    }

    private static class GAPRowSetDynaClass
    extends RowSetDynaClass {
        private static final long serialVersionUID = -8173007930963937299L;

        public GAPRowSetDynaClass(ResultSet resultSet, int i) throws SQLException {
            super(resultSet, i);
        }

        public GAPRowSetDynaClass(ResultSet resultSet, boolean b) throws SQLException {
            super(resultSet, b);
        }

        public GAPRowSetDynaClass(ResultSet resultSet, boolean b, int i) throws SQLException {
            super(resultSet, b, i);
        }

        public GAPRowSetDynaClass(ResultSet rs) throws SQLException {
            super(rs);
        }

        protected void copy(ResultSet resultSet) throws SQLException {
            int cnt = 0;
            while (resultSet.next() && (this.limit < 0 || cnt++ < this.limit)) {
                DynaBean bean = this.createDynaBean();
                for (DynaProperty property : this.properties) {
                    String className;
                    String name = property.getName();
                    Object o = resultSet.getObject(name);
                    if (o != null && ("java.sql.Date".equals(className = o.getClass().getName()) || className.startsWith("oracle.sql.TIMESTAMP"))) {
                        o = resultSet.getTimestamp(name);
                    }
                    bean.set(name, o);
                }
                this.rows.add(bean);
            }
        }

        protected DynaProperty createDynaProperty(ResultSetMetaData metadata, int i) throws SQLException {
            String name = this.lowerCase ? metadata.getColumnName(i).toLowerCase() : metadata.getColumnName(i);
            String className = null;
            try {
                className = metadata.getColumnClassName(i);
                if ("java.sql.Date".equals(className) || className.startsWith("oracle.sql.TIMESTAMP")) {
                    className = "java.sql.Timestamp";
                }
            }
            catch (SQLException e) {
                // empty catch block
            }
            Class clazz = Object.class;
            if (className != null) {
                clazz = this.loadClass(className);
            }
            return new DynaProperty(name, clazz);
        }
    }
}

