/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.core.customreports;

import edu.mit.broad.core.common.BroadCoreBaseDAO;
import edu.mit.broad.core.customreports.CustomReport;
import edu.mit.broad.core.customreports.CustomReportCategory;
import edu.mit.broad.core.customreports.CustomReportParameter;
import edu.mit.broad.core.customreports.CustomReportRole;
import edu.mit.broad.core.customreports.ReportDomain;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class CustomReportDAO
extends BroadCoreBaseDAO<CustomReport> {
    public List<CustomReport> getReports(Long groupId, Long projectId, Long experimentId, Collection<ReportDomain> domains) {
        Criteria criteria = this.getSession().createCriteria(CustomReport.class);
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"groupId", (Object)groupId), (Criterion)Restrictions.isNull((String)"groupId")));
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"projectId", (Object)projectId), (Criterion)Restrictions.isNull((String)"projectId")));
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"experimentId", (Object)experimentId), (Criterion)Restrictions.isNull((String)"experimentId")));
        if (domains == null) {
            criteria.add(Restrictions.isNull((String)"domain"));
        } else {
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.in((String)"domain", domains), (Criterion)Restrictions.isNull((String)"domain")));
        }
        criteria.addOrder(Order.asc((String)"name"));
        return criteria.list();
    }

    public CustomReport merge(CustomReport report) {
        return (CustomReport)this.getSession().merge((Object)report);
    }

    @Override
    public void delete(CustomReportParameter param) {
        param = (CustomReportParameter)this.getSession().get(CustomReportParameter.class, (Serializable)param.getParameterId());
        if (param != null) {
            this.getSession().delete((Object)param);
        }
    }

    @Override
    public void delete(CustomReportCategory category) {
        CustomReportCategory persistedCategory = (CustomReportCategory)this.getSession().get(CustomReportCategory.class, (Serializable)category.getCategoryId());
        if (persistedCategory != null) {
            this.getSession().delete((Object)persistedCategory);
        }
    }

    @Override
    public void delete(CustomReportRole role) {
        CustomReportRole persistedrole = (CustomReportRole)this.getSession().get(CustomReportRole.class, (Serializable)role.getRoleId());
        if (persistedrole != null) {
            this.getSession().delete((Object)persistedrole);
        }
    }

    public CustomReport getHydratedReport(long reportId) throws Exception {
        Session session = this.getSession();
        Criteria c = session.createCriteria(CustomReport.class).add((Criterion)Restrictions.eq((String)"reportId", (Object)reportId)).setFetchMode("domain", FetchMode.JOIN).setFetchMode("categories", FetchMode.JOIN).setFetchMode("parameters", FetchMode.JOIN);
        return (CustomReport)c.uniqueResult();
    }

    public CustomReport findByName(String name) {
        Session session = this.getSession();
        Criteria c = session.createCriteria(CustomReport.class).add((Criterion)Restrictions.eq((String)"name", (Object)name));
        return (CustomReport)c.uniqueResult();
    }

    public List<CustomReportCategory> getReportCategoriesByNames(SortedSet<String> categoryNames) {
        return this.getSession().createCriteria(CustomReportCategory.class).add(Restrictions.in((String)"name", categoryNames)).list();
    }

    public void saveCategory(CustomReportCategory newCategory) {
        this.getSession().save((Object)newCategory);
    }

    public void evict(CustomReport report) {
        this.getSession().evict((Object)report);
    }

    public List<CustomReportCategory> getReportCategories(long reportId) {
        return this.getSession().createCriteria(CustomReportCategory.class).add((Criterion)Restrictions.eq((String)"reportId", (Object)reportId)).addOrder(Order.asc((String)"categoryId")).list();
    }

    public List<CustomReportRole> getReportRoles(long reportId) {
        return this.getSession().createCriteria(CustomReportRole.class).add((Criterion)Restrictions.eq((String)"reportId", (Object)reportId)).list();
    }

    public List<CustomReport> getReports(Long groupId, Long projectId, Long experimentId, List<ReportDomain> domains, List<String> roles, List<String> categories) {
        ArrayList<CustomReport> customReports = new ArrayList<CustomReport>();
        Criteria emptyRolesCriteria = this.getSession().createCriteria(CustomReport.class);
        emptyRolesCriteria.add(Restrictions.isEmpty((String)"roles"));
        emptyRolesCriteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"groupId", (Object)groupId), (Criterion)Restrictions.isNull((String)"groupId")));
        emptyRolesCriteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"projectId", (Object)projectId), (Criterion)Restrictions.isNull((String)"projectId")));
        emptyRolesCriteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"experimentId", (Object)experimentId), (Criterion)Restrictions.isNull((String)"experimentId")));
        if (domains == null) {
            emptyRolesCriteria.add(Restrictions.isNull((String)"domain"));
        } else {
            emptyRolesCriteria.add((Criterion)Restrictions.or((Criterion)Restrictions.in((String)"domain", domains), (Criterion)Restrictions.isNull((String)"domain")));
        }
        if (categories != null && !categories.isEmpty() && (roles == null || roles.isEmpty())) {
            Criteria criteria = this.getSession().createCriteria(CustomReport.class);
            Criteria criteriaCategories = criteria.createCriteria("categories");
            criteriaCategories.add(Restrictions.in((String)"name", categories));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"groupId", (Object)groupId), (Criterion)Restrictions.isNull((String)"groupId")));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"projectId", (Object)projectId), (Criterion)Restrictions.isNull((String)"projectId")));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"experimentId", (Object)experimentId), (Criterion)Restrictions.isNull((String)"experimentId")));
            if (domains == null) {
                criteria.add(Restrictions.isNull((String)"domain"));
            } else {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.in((String)"domain", domains), (Criterion)Restrictions.isNull((String)"domain")));
            }
            criteria.addOrder(Order.asc((String)"name"));
            customReports.addAll(criteria.list());
        } else if (roles != null && !roles.isEmpty()) {
            Criteria criteria = this.getSession().createCriteria(CustomReport.class);
            Criteria criteriaRoles = criteria.createCriteria("roles");
            criteriaRoles.add(Restrictions.in((String)"roleName", roles));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"groupId", (Object)groupId), (Criterion)Restrictions.isNull((String)"groupId")));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"projectId", (Object)projectId), (Criterion)Restrictions.isNull((String)"projectId")));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"experimentId", (Object)experimentId), (Criterion)Restrictions.isNull((String)"experimentId")));
            if (domains == null) {
                criteria.add(Restrictions.isNull((String)"domain"));
            } else {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.in((String)"domain", domains), (Criterion)Restrictions.isNull((String)"domain")));
            }
            if (categories != null && !categories.isEmpty()) {
                Criteria criteriaCategories = criteria.createCriteria("categories");
                criteriaCategories.add(Restrictions.in((String)"name", roles));
            }
            criteria.addOrder(Order.asc((String)"name"));
            customReports.addAll(criteria.list());
        }
        customReports.addAll(emptyRolesCriteria.list());
        return customReports;
    }
}

