/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.core.customreports;

import edu.mit.broad.core.customreports.CategoryComparator;
import edu.mit.broad.core.customreports.CustomReportCategory;
import edu.mit.broad.core.customreports.CustomReportParameter;
import edu.mit.broad.core.customreports.CustomReportRole;
import edu.mit.broad.core.customreports.ReportDomain;
import edu.mit.broad.core.customreports.RoleComparator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.SortedSet;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.IndexColumn;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Sort;
import org.hibernate.annotations.SortType;

@Entity
public class CustomReport {
    private static String DATE_PATTERN = "MM/dd/yyyy";
    private long reportId;
    private Long groupId;
    private Long projectId;
    private Long experimentId;
    private String name;
    private String description;
    private ReportDomain domain;
    private String dataSourceName;
    private String data;
    private SortedSet<CustomReportCategory> categories;
    private SortedSet<CustomReportRole> roles;
    private Date createdDate;
    private String createdBy;
    private Date lastRunDate;
    private String lastRunBy;
    private Long runCount;
    private String reportType;
    private List<CustomReportParameter> parameters = new ArrayList<CustomReportParameter>();

    @Id
    @GeneratedValue(generator="GenCustRep")
    @GenericGenerator(name="GenCustRep", strategy="sequence", parameters={@Parameter(name="sequence", value="sq_custom_report")})
    public long getReportId() {
        return this.reportId;
    }

    public void setReportId(long reportId) {
        this.reportId = reportId;
    }

    public Long getGroupId() {
        return this.groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getExperimentId() {
        return this.experimentId;
    }

    public void setExperimentId(Long experimentId) {
        this.experimentId = experimentId;
    }

    @Column(unique=true, nullable=false)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Enumerated(value=EnumType.STRING)
    public ReportDomain getDomain() {
        return this.domain;
    }

    public void setDomain(ReportDomain domain) {
        this.domain = domain;
    }

    @Column(name="ds_name")
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    @OneToMany(fetch=FetchType.EAGER, mappedBy="reportId")
    @Sort(type=SortType.COMPARATOR, comparator=CategoryComparator.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public SortedSet<CustomReportCategory> getCategories() {
        return this.categories;
    }

    public void setCategories(SortedSet<CustomReportCategory> categories) {
        this.categories = categories;
    }

    @OneToMany(fetch=FetchType.EAGER, mappedBy="reportId")
    @Sort(type=SortType.COMPARATOR, comparator=RoleComparator.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public SortedSet<CustomReportRole> getRoles() {
        return this.roles;
    }

    public void setRoles(SortedSet<CustomReportRole> roles) {
        this.roles = roles;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Date getLastRunDate() {
        return this.lastRunDate;
    }

    public void setLastRunDate(Date lastRunDate) {
        this.lastRunDate = lastRunDate;
    }

    public String getLastRunBy() {
        return this.lastRunBy;
    }

    public void setLastRunBy(String lastRunBy) {
        this.lastRunBy = lastRunBy;
    }

    public Long getRunCount() {
        return this.runCount;
    }

    public void setRunCount(Long runCount) {
        this.runCount = runCount;
    }

    public String getReportType() {
        return this.reportType;
    }

    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    @Transient
    public String getCreatedDateString() {
        return this.formatDate(this.getCreatedDate());
    }

    @Transient
    public String getLastRunDateString() {
        return this.formatDate(this.getLastRunDate());
    }

    @Transient
    private String formatDate(Date date) {
        String formattedDate = "";
        if (date != null) {
            SimpleDateFormat defaultDateFormat = new SimpleDateFormat(DATE_PATTERN);
            return defaultDateFormat.format(date);
        }
        return formattedDate;
    }

    @Transient
    public String getCategoryList() {
        String separator = "";
        String categoryList = "";
        if (this.getCategories() != null) {
            for (CustomReportCategory category : this.getCategories()) {
                categoryList = categoryList + separator + category.getName();
                separator = ", ";
            }
        }
        return categoryList;
    }

    @Transient
    public String getRoleList() {
        String separator = "";
        String roleList = "";
        if (this.getRoles() != null) {
            for (CustomReportRole role : this.getRoles()) {
                roleList = roleList + separator + role.getRoleName();
                separator = ", ";
            }
        }
        return roleList;
    }

    @OneToMany(cascade={CascadeType.ALL})
    @JoinColumn(name="report_id")
    @IndexColumn(name="idx")
    public List<CustomReportParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<CustomReportParameter> parameters) {
        this.parameters = parameters;
    }

    @Transient
    CustomReportParameter getParameter(String name) {
        for (CustomReportParameter p : this.getParameters()) {
            if (!name.equals(p.getName())) continue;
            return p;
        }
        return null;
    }
}

