/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.core.common;

import edu.mit.broad.core.common.ParameterType;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.TypeConverter;
import net.sourceforge.stripes.validation.TypeConverterFactory;
import net.sourceforge.stripes.validation.ValidationError;
import net.sourceforge.stripes.validation.ValidationErrors;

public class ParameterConverter {
    private static final Pattern SPLIT_PATTERN = Pattern.compile(",\\s*");

    public void convertParameters(Map<String, String[]> variables, Map<String, Object> typedVariables, Collection<? extends ParameterType> parameters, Locale locale, ValidationErrors validationErrors) {
        try {
            TypeConverterFactory tcf = StripesFilter.getConfiguration().getTypeConverterFactory();
            for (ParameterType parameterType : parameters) {
                ArrayList errors = new ArrayList();
                String name = parameterType.getName();
                String[] value = variables.get(name);
                if (parameterType.getType().isArray()) {
                    Class arrayType = parameterType.getType();
                    Class<?> componentType = arrayType.getComponentType();
                    if (value == null || value.length == 0) {
                        typedVariables.put(name, Array.newInstance(componentType, 0));
                    } else {
                        ArrayList<Object> list = new ArrayList<Object>();
                        TypeConverter tc = tcf.getTypeConverter(componentType, locale);
                        for (String singleValue : value) {
                            for (String value1 : SPLIT_PATTERN.split(singleValue)) {
                                list.add(tc.convert(value1, componentType, errors));
                            }
                        }
                        Object convertedValues = Array.newInstance(componentType, list.size());
                        for (int i = 0; i < list.size(); ++i) {
                            Array.set(convertedValues, i, list.get(i));
                        }
                        typedVariables.put(name, convertedValues);
                    }
                } else if (value != null && value.length > 0 && value[0] != null) {
                    Class typeClass = parameterType.getType();
                    TypeConverter tc = tcf.getTypeConverter(typeClass, locale);
                    Object convertedValue = tc.convert(value[0], typeClass, errors);
                    typedVariables.put(name, convertedValue);
                }
                if (errors.isEmpty()) continue;
                for (ValidationError err : errors) {
                    this.addError(parameterType, value[0], validationErrors, err);
                }
            }
        }
        catch (Throwable e) {
            validationErrors.addGlobalError((ValidationError)new SimpleError("Failed variable type conversion: " + e.getMessage(), new Object[0]));
        }
    }

    protected void addError(ParameterType param, String value, ValidationErrors errors, ValidationError error) {
        error.setFieldValue(value);
        errors.add(param.getName(), error);
        error.setFieldName(param.getDescription());
    }
}

