/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.core.common;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.criterion.Criterion;

public abstract class BaseHibernateDAO<PersistentType> {
    private static Map<Class, Class> returnTypes = new Hashtable<Class, Class>();

    protected Class getType() {
        Class type = returnTypes.get(this.getClass());
        if (type != null) {
            return type;
        }
        try {
            ParameterizedType ptype = (ParameterizedType)this.getClass().getGenericSuperclass();
            type = (Class)ptype.getActualTypeArguments()[0];
            returnTypes.put(this.getClass(), type);
            return type;
        }
        catch (Exception exc) {
            throw new RuntimeException("Big trouble: Cannot find type parameter for DAO " + this.getClass() + " with superclass " + this.getClass().getGenericSuperclass(), exc);
        }
    }

    protected abstract SessionFactory getSessionFactory();

    protected Session getSession() {
        SessionFactory sf = this.getSessionFactory();
        try {
            return sf.getCurrentSession();
        }
        catch (HibernateException he) {
            return sf.openSession();
        }
    }

    protected StatelessSession getStatelessSession() {
        return this.getSessionFactory().openStatelessSession();
    }

    public PersistentType get(long id) {
        return (PersistentType)this.getSession().load(this.getType(), (Serializable)Long.valueOf(id));
    }

    public boolean exists(long id) {
        try {
            return this.getSession().get(this.getType(), (Serializable)Long.valueOf(id)) != null;
        }
        catch (ObjectDeletedException ex) {
            return false;
        }
    }

    public List<PersistentType> getAll() {
        return this.findByCriteria(new Criterion[0]);
    }

    public PersistentType save(PersistentType nonPersistentEntity) {
        this.getSession().save(nonPersistentEntity);
        return nonPersistentEntity;
    }

    public PersistentType update(PersistentType persistentEntity) {
        this.getSession().update(persistentEntity);
        return persistentEntity;
    }

    public PersistentType saveOrUpdate(PersistentType persistentEntity) {
        this.getSession().saveOrUpdate(persistentEntity);
        return persistentEntity;
    }

    public void delete(PersistentType persistentEntity) {
        this.getSession().delete(persistentEntity);
    }

    protected List<PersistentType> findByCriteria(Criterion ... criterion) {
        Criteria crit = this.getSession().createCriteria(this.getType());
        for (Criterion c : criterion) {
            crit.add(c);
        }
        return crit.list();
    }

    protected PersistentType findUniqueByCriteria(Criterion ... criterion) {
        Criteria crit = this.getSession().createCriteria(this.getType());
        for (Criterion c : criterion) {
            crit.add(c);
        }
        return (PersistentType)crit.uniqueResult();
    }

    public static String generatePattern(String pattern, char escapeChar) {
        StringBuffer buffer = new StringBuffer(pattern.length());
        buffer.append('%');
        for (int i = 0; i < pattern.length(); ++i) {
            char ch = pattern.charAt(i);
            if (ch == '%' || ch == '_' || ch == escapeChar) {
                buffer.append(escapeChar);
            }
            buffer.append(ch);
        }
        buffer.append('%');
        return buffer.toString();
    }
}

