/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.core;

import edu.mit.broad.core.BroadCoreException;
import edu.mit.broad.core.lsf.LsfWrapper;
import edu.mit.broad.core.util.HibernateBuilder;
import edu.mit.broad.core.util.JndiUtil;
import java.sql.Connection;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public class Main {
    private static Main instance = null;
    private String environment;
    private String dataSourceName;
    private int lsfCheckFrequency = 30;
    private boolean lsfStarted = false;
    private Properties hibernateOptions;
    private SessionFactory sessionFactory;

    private Main() {
    }

    public static synchronized Main getInstance() {
        if (instance == null) {
            instance = new Main();
        }
        return instance;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setHibernateOptions(Properties hibernateOptions) {
        this.hibernateOptions = hibernateOptions;
    }

    public void setLsfCheckFrequency(int lsfCheckFrequency) {
        this.lsfCheckFrequency = lsfCheckFrequency;
    }

    public synchronized void start() {
        if (this.dataSourceName == null) {
            throw new BroadCoreException("You must supply a datasource JNDI name.");
        }
        Properties props = HibernateBuilder.getDefaultProperties();
        props.putAll((Map<?, ?>)this.hibernateOptions);
        if (!props.containsKey("hibernate.connection.datasource") && !props.containsKey("hibernate.connection.url")) {
            props.put("hibernate.connection.datasource", this.dataSourceName);
        }
        HibernateBuilder builder = new HibernateBuilder();
        builder.setProperties(props);
        builder.addAnnotatedPackages("edu.mit.broad.core");
        this.sessionFactory = builder.build();
        if (this.lsfCheckFrequency != 0) {
            this.lsfStarted = new LsfWrapper().start(this.lsfCheckFrequency);
        }
    }

    public synchronized void stop() {
        if (this.lsfStarted) {
            new LsfWrapper().stop();
        }
        this.sessionFactory.close();
        this.sessionFactory = null;
    }

    public Connection getConnection() {
        try {
            DataSource ds = (DataSource)JndiUtil.lookup(this.dataSourceName);
            return ds.getConnection();
        }
        catch (Exception e) {
            throw new BroadCoreException("Could not create a database connection via datasource: " + this.dataSourceName, e);
        }
    }

    public SessionFactory getHibernateSessionFactory() {
        if (this.sessionFactory == null) {
            throw new BroadCoreException("Cannot access hibernate session until Broad Core is started.");
        }
        return this.sessionFactory;
    }

    public Session getHibernateSession() {
        return this.getHibernateSessionFactory().getCurrentSession();
    }

    private void setHibernateProperty(String name, String value) {
        if (this.hibernateOptions == null) {
            this.hibernateOptions = new Properties();
        }
        if (!this.hibernateOptions.containsKey(name)) {
            this.hibernateOptions.put(name, value);
        }
    }
}

