/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.tribble.util.HttpUtils;
import org.broad.tribble.util.SeekableStream;

public class SeekableHTTPStream
extends SeekableStream {
    static Logger log = Logger.getLogger(SeekableHTTPStream.class);
    private long position = 0L;
    private long contentLength = -1L;
    private URL url;

    public SeekableHTTPStream(URL url) {
        String contentLengthString;
        this.url = url;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating SeekableHTTPStream for: " + url));
        }
        if ((contentLengthString = HttpUtils.getHeaderField(url, "Content-Length")) != null) {
            try {
                this.contentLength = Long.parseLong(contentLengthString);
            }
            catch (NumberFormatException e) {
                log.error((Object)("Error converting content length to number: " + this.contentLength));
            }
        }
    }

    @Override
    public void seek(long position) {
        this.position = position;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public long skip(long n) throws IOException {
        long bytesToSkip = Math.min(n, this.contentLength - this.position);
        this.position += bytesToSkip;
        return bytesToSkip;
    }

    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("read: " + offset + " " + len));
        }
        if (offset < 0 || len < 0 || offset + len > buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        HttpURLConnection connection = null;
        InputStream is = null;
        String byteRange = "";
        int n = 0;
        try {
            connection = HttpUtils.openConnection(this.url);
            long endRange = this.position + (long)len - 1L;
            if (this.contentLength > 0L) {
                endRange = Math.min(endRange, this.contentLength);
            }
            byteRange = "bytes=" + this.position + "-" + endRange;
            connection.setRequestProperty("Range", byteRange);
            is = connection.getInputStream();
            while (n < len) {
                int count = is.read(buffer, offset + n, len - n);
                if (count < 0) {
                    if (n != 0) break;
                    int n2 = -1;
                    return n2;
                }
                n += count;
            }
            this.position += (long)n;
            int n3 = n;
            return n3;
        }
        catch (IOException e) {
            if (e.getMessage().contains("416") || e instanceof EOFException) {
                if (n < 0) {
                    int n4 = -1;
                    return n4;
                }
                this.position += (long)n;
                this.contentLength = this.position;
                int n5 = n;
                return n5;
            }
            throw e;
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int read() throws IOException {
        throw new UnsupportedOperationException("read() is not supported on SeekableHTTPStream.  Must read in blocks.");
    }

    private void logHeaderFields(HttpURLConnection connection) {
        Map<String, List<String>> map = connection.getHeaderFields();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            System.out.print(entry.getKey() + ":\t");
            for (String v : entry.getValue()) {
                System.out.print(v + " ");
            }
            System.out.println();
        }
    }
}

