/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.util;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class LEDataOutputStream {
    private static final String EMBEDDED_COPYRIGHT = "copyright (c) 1999-2010 Roedy Green, Canadian Mind Products, http://mindprod.com";
    protected final DataOutputStream dis;
    protected final byte[] work;

    public LEDataOutputStream(OutputStream out) {
        this.dis = new DataOutputStream(out);
        this.work = new byte[8];
    }

    public final void close() throws IOException {
        this.dis.close();
    }

    public void flush() throws IOException {
        this.dis.flush();
    }

    public final int size() {
        return this.dis.size();
    }

    public final synchronized void write(int ib) throws IOException {
        this.dis.write(ib);
    }

    public final void write(byte[] ba) throws IOException {
        this.dis.write(ba, 0, ba.length);
    }

    public final synchronized void write(byte[] ba, int off, int len) throws IOException {
        this.dis.write(ba, off, len);
    }

    public final void writeBoolean(boolean v) throws IOException {
        this.dis.writeBoolean(v);
    }

    public final void writeByte(int v) throws IOException {
        this.dis.writeByte(v);
    }

    public final void writeBytes(String s) throws IOException {
        this.dis.writeBytes(s);
    }

    public final void writeChar(int v) throws IOException {
        this.work[0] = (byte)v;
        this.work[1] = (byte)(v >> 8);
        this.dis.write(this.work, 0, 2);
    }

    public final void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.writeChar(s.charAt(i));
        }
    }

    public final void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public final void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public final void writeInt(int v) throws IOException {
        this.work[0] = (byte)v;
        this.work[1] = (byte)(v >> 8);
        this.work[2] = (byte)(v >> 16);
        this.work[3] = (byte)(v >> 24);
        this.dis.write(this.work, 0, 4);
    }

    public final void writeLong(long v) throws IOException {
        this.work[0] = (byte)v;
        this.work[1] = (byte)(v >> 8);
        this.work[2] = (byte)(v >> 16);
        this.work[3] = (byte)(v >> 24);
        this.work[4] = (byte)(v >> 32);
        this.work[5] = (byte)(v >> 40);
        this.work[6] = (byte)(v >> 48);
        this.work[7] = (byte)(v >> 56);
        this.dis.write(this.work, 0, 8);
    }

    public final void writeShort(int v) throws IOException {
        this.work[0] = (byte)v;
        this.work[1] = (byte)(v >> 8);
        this.dis.write(this.work, 0, 2);
    }

    public void writeString(String s) throws IOException {
        this.write(s.getBytes());
        this.writeByte(0);
    }
}

