/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.util;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class LEDataInputStream {
    private static final String EMBEDDED_COPYRIGHT = "copyright (c) 1999-2010 Roedy Green, Canadian Mind Products, http://mindprod.com";
    protected final DataInputStream dis;
    protected final InputStream is;
    protected final byte[] work;
    protected byte[] stringBuffer;

    public static String readUTF(DataInput in) throws IOException {
        return DataInputStream.readUTF(in);
    }

    public LEDataInputStream(InputStream in) {
        this.is = in;
        this.dis = new DataInputStream(in);
        this.work = new byte[8];
        this.stringBuffer = new byte[1024];
    }

    public final void close() throws IOException {
        this.dis.close();
    }

    public final int read(byte[] ba, int off, int len) throws IOException {
        return this.is.read(ba, off, len);
    }

    public final boolean readBoolean() throws IOException {
        return this.dis.readBoolean();
    }

    public final byte readByte() throws IOException {
        return this.dis.readByte();
    }

    public final char readChar() throws IOException {
        this.dis.readFully(this.work, 0, 2);
        return (char)((this.work[1] & 0xFF) << 8 | this.work[0] & 0xFF);
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final void readFully(byte[] ba) throws IOException {
        this.dis.readFully(ba, 0, ba.length);
    }

    public final void readFully(byte[] ba, int off, int len) throws IOException {
        this.dis.readFully(ba, off, len);
    }

    public final int readInt() throws IOException {
        this.dis.readFully(this.work, 0, 4);
        return this.work[3] << 24 | (this.work[2] & 0xFF) << 16 | (this.work[1] & 0xFF) << 8 | this.work[0] & 0xFF;
    }

    public final String readLine() throws IOException {
        return this.dis.readLine();
    }

    public final long readLong() throws IOException {
        this.dis.readFully(this.work, 0, 8);
        return (long)this.work[7] << 56 | (long)(this.work[6] & 0xFF) << 48 | (long)(this.work[5] & 0xFF) << 40 | (long)(this.work[4] & 0xFF) << 32 | (long)(this.work[3] & 0xFF) << 24 | (long)(this.work[2] & 0xFF) << 16 | (long)(this.work[1] & 0xFF) << 8 | (long)(this.work[0] & 0xFF);
    }

    public final short readShort() throws IOException {
        this.dis.readFully(this.work, 0, 2);
        return (short)((this.work[1] & 0xFF) << 8 | this.work[0] & 0xFF);
    }

    public final int readUnsignedByte() throws IOException {
        return this.dis.readUnsignedByte();
    }

    public final int readUnsignedShort() throws IOException {
        this.dis.readFully(this.work, 0, 2);
        return (this.work[1] & 0xFF) << 8 | this.work[0] & 0xFF;
    }

    public final int skipBytes(int n) throws IOException {
        return this.dis.skipBytes(n);
    }

    public String readString() throws IOException {
        int b = -1;
        int nBytes = 0;
        while (true) {
            byte by = this.readByte();
            b = by;
            if (by == 0) break;
            this.stringBuffer[nBytes] = b;
            ++nBytes;
        }
        return new String(this.stringBuffer, 0, nBytes);
    }
}

