/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.readers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import net.sf.samtools.util.BlockCompressedInputStream;
import org.broad.tribble.readers.QueryReader;
import org.broad.tribble.util.LineReader;

public class TabixReader
implements QueryReader,
LineReader {
    private String filename;
    private BlockCompressedInputStream blockCompressedInputStream;
    private int format;
    private int seqCol;
    private int begCol;
    private int endCol;
    private int metaChar;
    private int nSkip;
    private String[] sequences;
    private HashMap<String, Integer> chr2tid;
    private static int MAX_BIN = 37450;
    private static int TAD_MIN_CHUNK_GAP = 32768;
    private static int TAD_LIDX_SHIFT = 14;
    private TIndex[] mIndex;

    private static boolean less64(long u, long v) {
        return u < v ^ u < 0L ^ v < 0L;
    }

    public TabixReader(String fn) throws IOException {
        this.filename = fn;
        this.blockCompressedInputStream = fn.startsWith("http:") ? new BlockCompressedInputStream(new URL(fn)) : new BlockCompressedInputStream(new File(fn));
        this.readIndex();
    }

    public Set<String> getSequenceNames() {
        return this.chr2tid.keySet();
    }

    private static int reg2bins(int beg, int _end, int[] list) {
        int i = 0;
        int end = _end;
        --end;
        list[i++] = 0;
        int k = 1 + (beg >> 26);
        while (k <= 1 + (end >> 26)) {
            list[i++] = k++;
        }
        k = 9 + (beg >> 23);
        while (k <= 9 + (end >> 23)) {
            list[i++] = k++;
        }
        k = 73 + (beg >> 20);
        while (k <= 73 + (end >> 20)) {
            list[i++] = k++;
        }
        k = 585 + (beg >> 17);
        while (k <= 585 + (end >> 17)) {
            list[i++] = k++;
        }
        k = 4681 + (beg >> 14);
        while (k <= 4681 + (end >> 14)) {
            list[i++] = k++;
        }
        return i;
    }

    public static int readInt(InputStream is) throws IOException {
        byte[] buf = new byte[4];
        is.read(buf);
        return ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    public static long readLong(InputStream is) throws IOException {
        byte[] buf = new byte[8];
        is.read(buf);
        return ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN).getLong();
    }

    public static String readNextLine(InputStream is) throws IOException {
        int c;
        StringBuffer buf = new StringBuffer();
        while ((c = is.read()) >= 0 && c != 10) {
            buf.append((char)c);
        }
        if (c < 0) {
            return null;
        }
        return buf.toString();
    }

    public void readIndex(BlockCompressedInputStream is) throws IOException {
        int i;
        byte[] buf = new byte[4];
        is.read(buf, 0, 4);
        this.sequences = new String[TabixReader.readInt((InputStream)is)];
        this.chr2tid = new HashMap();
        this.format = TabixReader.readInt((InputStream)is);
        this.seqCol = TabixReader.readInt((InputStream)is);
        this.begCol = TabixReader.readInt((InputStream)is);
        this.endCol = TabixReader.readInt((InputStream)is);
        this.metaChar = TabixReader.readInt((InputStream)is);
        this.nSkip = TabixReader.readInt((InputStream)is);
        int l = TabixReader.readInt((InputStream)is);
        buf = new byte[l];
        is.read(buf);
        int k = 0;
        int j = 0;
        for (i = 0; i < buf.length; ++i) {
            if (buf[i] != 0) continue;
            byte[] b = new byte[i - j];
            System.arraycopy(buf, j, b, 0, b.length);
            String s = new String(b);
            this.chr2tid.put(s, k);
            this.sequences[k++] = s;
            j = i + 1;
        }
        this.mIndex = new TIndex[this.sequences.length];
        for (i = 0; i < this.sequences.length; ++i) {
            int n_bin = TabixReader.readInt((InputStream)is);
            this.mIndex[i] = new TIndex();
            this.mIndex[i].b = new HashMap();
            for (j = 0; j < n_bin; ++j) {
                int bin = TabixReader.readInt((InputStream)is);
                TPair64[] chunks = new TPair64[TabixReader.readInt((InputStream)is)];
                for (k = 0; k < chunks.length; ++k) {
                    long u = TabixReader.readLong((InputStream)is);
                    long v = TabixReader.readLong((InputStream)is);
                    chunks[k] = new TPair64(u, v);
                }
                this.mIndex[i].b.put(bin, chunks);
            }
            this.mIndex[i].l = new long[TabixReader.readInt((InputStream)is)];
            for (k = 0; k < this.mIndex[i].l.length; ++k) {
                this.mIndex[i].l[k] = TabixReader.readLong((InputStream)is);
            }
        }
        is.close();
    }

    public void readIndex() throws IOException {
        BlockCompressedInputStream bcis = null;
        bcis = this.filename.startsWith("http:") ? new BlockCompressedInputStream(new URL(this.filename + ".tbi")) : new BlockCompressedInputStream(new File(this.filename + ".tbi"));
        this.readIndex(bcis);
    }

    @Override
    public String readLine() throws IOException {
        return TabixReader.readNextLine((InputStream)this.blockCompressedInputStream);
    }

    private int chr2tid(String chr) {
        if (this.chr2tid.containsKey(chr)) {
            return this.chr2tid.get(chr);
        }
        return -1;
    }

    public int[] parseReg(String reg) {
        int[] ret = new int[3];
        int colon = reg.indexOf(58);
        int hyphen = reg.indexOf(45);
        String chr = colon >= 0 ? reg.substring(0, colon) : reg;
        ret[1] = colon >= 0 ? Integer.parseInt(reg.substring(colon + 1, hyphen)) - 1 : 0;
        ret[2] = hyphen >= 0 ? Integer.parseInt(reg.substring(hyphen + 1)) : Integer.MAX_VALUE;
        ret[0] = this.chr2tid(chr);
        return ret;
    }

    private TIntv getIntv(String s) {
        TIntv intv = new TIntv();
        int col = 0;
        int end = 0;
        int beg = 0;
        while ((end = s.indexOf(9, beg)) >= 0) {
            int i;
            if (++col == this.seqCol) {
                intv.tid = this.chr2tid(s.substring(beg, end));
            } else if (col == this.begCol) {
                intv.end = Integer.parseInt(s.substring(beg, end));
                intv.beg = intv.end++;
                if ((this.format & 0x10000) == 0) {
                    --intv.beg;
                }
            } else if ((this.format & 0xFFFF) == 0) {
                if (col == this.endCol) {
                    intv.end = Integer.parseInt(s.substring(beg, end));
                }
            } else if ((this.format & 0xFFFF) == 1) {
                if (col == 6) {
                    int l = 0;
                    String cigar = s.substring(beg, end);
                    int j = 0;
                    for (i = 0; i < cigar.length(); ++i) {
                        char op;
                        if (cigar.charAt(i) <= '9' || (op = cigar.charAt(i)) != 'M' && op != 'D' && op != 'N') continue;
                        l += Integer.parseInt(cigar.substring(j, i));
                    }
                    intv.end = intv.beg + l;
                }
            } else if ((this.format & 0xFFFF) == 2 && col == 5) {
                String alt = s.substring(beg, end);
                int max = 1;
                for (i = 0; i < alt.length(); ++i) {
                    int j;
                    if (alt.charAt(i) != 'D') continue;
                    for (j = i + 1; j < alt.length() && alt.charAt(j) >= '0' && alt.charAt(j) <= '9'; ++j) {
                    }
                    int l = Integer.parseInt(alt.substring(i + 1, j));
                    if (max < l) {
                        max = l;
                    }
                    i = j - 1;
                }
                intv.end = intv.beg + max;
            }
            beg = end + 1;
        }
        return intv;
    }

    private TabixLineReader query(int tid, int beg, int end) {
        TPair64[] chunks;
        int i;
        TIndex idx = this.mIndex[tid];
        int[] bins = new int[MAX_BIN];
        int n_bins = TabixReader.reg2bins(beg, end, bins);
        long min_off = beg >> TAD_LIDX_SHIFT >= idx.l.length ? 0L : idx.l[beg >> TAD_LIDX_SHIFT];
        int n_off = 0;
        for (i = 0; i < n_bins; ++i) {
            chunks = idx.b.get(bins[i]);
            if (chunks == null) continue;
            n_off += chunks.length;
        }
        if (n_off == 0) {
            return null;
        }
        Object[] off = new TPair64[n_off];
        n_off = 0;
        for (i = 0; i < n_bins; ++i) {
            chunks = idx.b.get(bins[i]);
            if (chunks == null) continue;
            for (int j = 0; j < chunks.length; ++j) {
                if (!TabixReader.less64(min_off, chunks[j].v)) continue;
                off[n_off++] = new TPair64(chunks[j]);
            }
        }
        Arrays.sort(off, 0, n_off);
        int l = 0;
        for (i = 1; i < n_off; ++i) {
            if (!TabixReader.less64(((TPair64)off[l]).v, ((TPair64)off[i]).v)) continue;
            ((TPair64)off[++l]).u = ((TPair64)off[i]).u;
            ((TPair64)off[l]).v = ((TPair64)off[i]).v;
        }
        n_off = l + 1;
        for (i = 1; i < n_off; ++i) {
            if (TabixReader.less64(((TPair64)off[i - 1]).v, ((TPair64)off[i]).u)) continue;
            ((TPair64)off[i - 1]).v = ((TPair64)off[i]).u;
        }
        l = 0;
        for (i = 1; i < n_off; ++i) {
            if (((TPair64)off[l]).v >> 16 == ((TPair64)off[i]).u >> 16) {
                ((TPair64)off[l]).v = ((TPair64)off[i]).v;
                continue;
            }
            ((TPair64)off[++l]).u = ((TPair64)off[i]).u;
            ((TPair64)off[l]).v = ((TPair64)off[i]).v;
        }
        n_off = l + 1;
        TPair64[] ret = new TPair64[n_off];
        for (i = 0; i < n_off; ++i) {
            ret[i] = new TPair64(((TPair64)off[i]).u, ((TPair64)off[i]).v);
        }
        return new TabixLineReader(tid, beg, end, ret);
    }

    public TabixLineReader query(String reg) {
        int[] x = this.parseReg(reg);
        return this.query(x[0], x[1], x[2]);
    }

    @Override
    public LineReader iterate() {
        return this;
    }

    @Override
    public TabixLineReader query(String chr, int start, int end) {
        int tid = this.chr2tid(chr);
        if (tid >= 0) {
            return this.query(this.chr2tid(chr), start - 1, end);
        }
        return null;
    }

    @Override
    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTabix(String path) {
        if (!path.endsWith("gz")) {
            return false;
        }
        BlockCompressedInputStream is = null;
        try {
            is = path.startsWith("http:") ? new BlockCompressedInputStream(new URL(path + ".tbi")) : new BlockCompressedInputStream(new File(path + ".tbi"));
            if (is == null) {
                boolean bl = false;
                return bl;
            }
            byte[] bytes = new byte[4];
            is.read(bytes);
            boolean bl = (char)bytes[0] == 'T' && (char)bytes[1] == 'B';
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void main(String[] args) {
        args = new String[]{"/Users/jrobinso/projects/Version_1.5_rc2/test/data/CEU.SRP000032.2010_03.genotypes.vcf.gz", "1:58003474-58013474"};
        if (args.length < 1) {
            System.out.println("Usage: java -cp .:sam.jar TabixReader <in.gz> [region]");
            System.exit(1);
        }
        System.out.println(TabixReader.isTabix(args[0]));
        try {
            TabixReader tr = new TabixReader(args[0]);
            if (args.length == 1) {
                String s;
                while ((s = tr.readLine()) != null) {
                    System.out.println(s);
                }
            } else {
                String s;
                TabixLineReader iter = tr.query(args[1]);
                while ((s = iter.readLine()) != null) {
                    System.out.println(s);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public class TabixLineReader
    implements LineReader {
        private int i = -1;
        private int n_seeks = 0;
        private int tid;
        private int beg;
        private int end;
        private TPair64[] off;
        private long curr_off = 0L;
        private boolean iseof = false;

        public TabixLineReader(int _tid, int _beg, int _end, TPair64[] _off) {
            this.off = _off;
            this.tid = _tid;
            this.beg = _beg;
            this.end = _end;
        }

        @Override
        public String readLine() throws IOException {
            block5: {
                String s;
                if (this.iseof) {
                    return null;
                }
                while (true) {
                    if (this.curr_off == 0L || !TabixReader.less64(this.curr_off, this.off[this.i].v)) {
                        if (this.i == this.off.length - 1) break block5;
                        if (this.i >= 0) assert (this.curr_off == this.off[this.i].v);
                        if (this.i < 0 || this.off[this.i].v != this.off[this.i + 1].u) {
                            TabixReader.this.blockCompressedInputStream.seek(this.off[this.i + 1].u);
                            this.curr_off = TabixReader.this.blockCompressedInputStream.getFilePointer();
                            ++this.n_seeks;
                        }
                        ++this.i;
                    }
                    if ((s = TabixReader.readNextLine((InputStream)TabixReader.this.blockCompressedInputStream)) == null) break block5;
                    char[] str = s.toCharArray();
                    this.curr_off = TabixReader.this.blockCompressedInputStream.getFilePointer();
                    if (str.length == 0 || str[0] == TabixReader.this.metaChar) continue;
                    TIntv intv = TabixReader.this.getIntv(s);
                    if (intv.tid != this.tid || intv.beg >= this.end) break block5;
                    if (intv.end > this.beg && intv.beg < this.end) break;
                }
                return s;
            }
            this.iseof = true;
            return null;
        }
    }

    private class TIntv {
        int tid;
        int beg;
        int end;

        private TIntv() {
        }
    }

    private class TIndex {
        HashMap<Integer, TPair64[]> b;
        long[] l;

        private TIndex() {
        }
    }

    private class TPair64
    implements Comparable<TPair64> {
        long u;
        long v;

        public TPair64(long _u, long _v) {
            this.u = _u;
            this.v = _v;
        }

        public TPair64(TPair64 p) {
            this.u = p.u;
            this.v = p.v;
        }

        @Override
        public int compareTo(TPair64 p) {
            return this.u == p.u ? 0 : (this.u < p.u ^ this.u < 0L ^ p.u < 0L ? -1 : 1);
        }
    }
}

