/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.readers;

import java.io.IOException;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.FeatureReader;
import org.broad.tribble.index.Index;
import org.broad.tribble.readers.AsciiQueryReader;
import org.broad.tribble.readers.QueryReader;
import org.broad.tribble.readers.TabixReader;
import org.broad.tribble.util.CloseableTribbleIterator;
import org.broad.tribble.util.LineReader;

public class BasicFeatureReader<T extends Feature>
implements FeatureReader {
    private static Logger log = Logger.getLogger(BasicFeatureReader.class);
    private QueryReader queryReader;
    protected FeatureCodec codec;

    public BasicFeatureReader(String featureFile, Index indexInstance, FeatureCodec codec) throws IOException {
        this.codec = codec;
        this.queryReader = new AsciiQueryReader(featureFile, indexInstance);
        this.readHeader();
    }

    public BasicFeatureReader(String featureFile, String indexFile, FeatureCodec codec) throws IOException {
        this.queryReader = new AsciiQueryReader(featureFile, indexFile);
        this.codec = codec;
        this.readHeader();
    }

    public BasicFeatureReader(String featureFile, FeatureCodec codec) throws IOException {
        if (featureFile.endsWith(".gz")) {
            this.queryReader = new TabixReader(featureFile);
        } else {
            String indexFile = featureFile + ".idx";
            this.queryReader = new AsciiQueryReader(featureFile, indexFile);
        }
        this.codec = codec;
        this.readHeader();
    }

    public void readHeader() throws IOException {
        this.codec.readHeader(this.queryReader.iterate());
    }

    @Override
    public void close() throws IOException {
        if (this.queryReader != null) {
            this.queryReader.close();
        }
    }

    public Object getHeader(Class clazz) throws ClassCastException {
        return this.codec.getHeader(clazz);
    }

    @Override
    public CloseableTribbleIterator<T> query(String chr, int start, int end) throws IOException {
        return this.query(chr, start, end, false);
    }

    @Override
    public CloseableTribbleIterator<T> iterator() throws IOException {
        return new IteratorImpl(this);
    }

    @Override
    public CloseableTribbleIterator<T> query(String chr, int start, int end, boolean contained) throws IOException {
        return new IteratorImpl(this, chr, start, end, contained);
    }

    public static class IteratorImpl<T extends Feature>
    implements CloseableTribbleIterator {
        private static Logger log = Logger.getLogger(IteratorImpl.class);
        String chr;
        int start;
        int end;
        boolean contained;
        T currentRecord;
        final LineReader reader;
        BasicFeatureReader<T> basicFeatureReader;

        IteratorImpl(BasicFeatureReader<T> basicFeatureReader) throws IOException {
            this.basicFeatureReader = basicFeatureReader;
            this.reader = ((BasicFeatureReader)basicFeatureReader).queryReader.iterate();
            basicFeatureReader.codec.readHeader(this.reader);
            this.readNextRecord();
        }

        IteratorImpl(BasicFeatureReader<T> basicFeatureReader, String sequence, int start, int end, boolean contained) throws IOException {
            this.basicFeatureReader = basicFeatureReader;
            this.chr = sequence;
            this.start = start;
            this.end = end;
            this.contained = contained;
            this.reader = ((BasicFeatureReader)basicFeatureReader).queryReader.query(this.chr, start, end);
            this.advanceToFirstRecord();
        }

        private T readNextRecord() throws IOException {
            String nextLine;
            this.currentRecord = null;
            while (this.currentRecord == null && this.reader != null && (nextLine = this.reader.readLine()) != null) {
                this.currentRecord = this.basicFeatureReader.codec.decode(nextLine);
            }
            return this.currentRecord;
        }

        private void advanceToFirstRecord() throws IOException {
            T record = this.readNextRecord();
            while (!(record == null || !this.currentRecord.getChr().equals(this.chr) || this.contained && this.currentRecord.getStart() >= this.start || !this.contained && this.currentRecord.getEnd() >= this.start)) {
                if (this.currentRecord.getStart() > this.end) {
                    this.currentRecord = null;
                    break;
                }
                record = this.readNextRecord();
            }
        }

        @Override
        public boolean hasNext() {
            if (this.chr == null) {
                return this.currentRecord != null;
            }
            return this.currentRecord != null && this.chr.equals(this.currentRecord.getChr()) && (this.contained ? this.currentRecord.getEnd() <= this.end : this.currentRecord.getStart() <= this.end);
        }

        @Override
        public T next() {
            T ret = this.currentRecord;
            try {
                this.readNextRecord();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read the next record, the last record was at " + ret.getChr() + ":" + ret.getStart() + "-" + ret.getEnd(), e);
            }
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported in Iterators");
        }

        public void close() {
        }

        @Override
        public Iterator<Feature> iterator() {
            return this;
        }
    }
}

