/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.index.tabix;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.util.BinaryCodec;
import net.sf.samtools.util.BlockCompressedInputStream;
import org.broad.tribble.index.Block;
import org.broad.tribble.index.Index;

public class TabixIndex
implements Index {
    private final File index;
    private final BinaryCodec inputBinaryCodec;
    private SAMSequenceDictionary dictionary;
    private static final String magicString = "TBI\u0001";
    private final Map<String, List<Bin>> binMapping = new LinkedHashMap<String, List<Bin>>();
    private final Map<String, List<LinearBin>> linearMapping = new LinkedHashMap<String, List<LinearBin>>();

    public TabixIndex(File indexFile) {
        this.index = indexFile;
        this.dictionary = new SAMSequenceDictionary();
        try {
            String[] sequences;
            this.inputBinaryCodec = new BinaryCodec((InputStream)new DataInputStream((InputStream)new BlockCompressedInputStream(indexFile)));
            byte[] bytes = new byte[4];
            this.inputBinaryCodec.readBytes(bytes);
            if (!magicString.equals(new String(bytes))) {
                throw new IllegalArgumentException("Magic String was expected to be TBI\u0001 but we saw " + new String(bytes));
            }
            int numberOfSequences = this.inputBinaryCodec.readInt();
            this.readUnusedVars();
            int sequenceBufferSize = this.inputBinaryCodec.readInt();
            for (String sequence : sequences = new String(this.inputBinaryCodec.readString(sequenceBufferSize)).split("\u0000")) {
                this.dictionary.addSequence(new SAMSequenceRecord(sequence, 0));
                this.getBins(this.inputBinaryCodec, sequence);
            }
            this.inputBinaryCodec.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to create block compressed stream from " + this.index);
        }
    }

    public void getBins(BinaryCodec codec, String sequenceName) {
        int loop;
        ArrayList<Bin> binList = new ArrayList<Bin>();
        ArrayList<LinearBin> linearList = new ArrayList<LinearBin>();
        int numberOfBins = this.inputBinaryCodec.readInt();
        for (loop = 0; loop < numberOfBins; ++loop) {
            binList.add(new Bin(codec));
        }
        this.binMapping.put(sequenceName, binList);
        numberOfBins = this.inputBinaryCodec.readInt();
        for (loop = 0; loop < numberOfBins; ++loop) {
            linearList.add(new LinearBin(codec));
        }
        this.linearMapping.put(sequenceName, linearList);
    }

    private void readUnusedVars() {
        int format = this.inputBinaryCodec.readInt();
        int seqCol = this.inputBinaryCodec.readInt();
        int begCol = this.inputBinaryCodec.readInt();
        int endCol = this.inputBinaryCodec.readInt();
        int metaChar = this.inputBinaryCodec.readInt();
        int nSkip = this.inputBinaryCodec.readInt();
    }

    @Override
    public List<Block> getChunks(String chr, int start, int end) {
        return null;
    }

    @Override
    public SAMSequenceDictionary getSequenceDictionary() {
        return this.dictionary;
    }

    @Override
    public void setSequenceDictionary(SAMSequenceDictionary dictionary) {
        this.dictionary = dictionary;
    }

    @Override
    public boolean isCurrentVersion() {
        return true;
    }

    public static class LinearBin {
        private long offset = 0L;

        public LinearBin(BinaryCodec bcis) {
            this.offset = bcis.readLong();
        }
    }

    public static class Bin {
        private long binNumber = 0L;
        private int chunkCount = 0;
        private List<Long> offsetStart = new ArrayList<Long>();
        private List<Long> offsetStop = new ArrayList<Long>();

        public Bin(BinaryCodec bcis) {
            this.binNumber = bcis.readUInt();
            this.chunkCount = bcis.readInt();
            for (int x = 0; x < this.chunkCount; ++x) {
                this.offsetStart.add(bcis.readLong());
                this.offsetStop.add(bcis.readLong());
            }
        }
    }
}

