/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.index.linear;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.exception.UnsortedFileException;
import org.broad.tribble.index.linear.LinearIndex;
import org.broad.tribble.util.AsciiLineReader;

public class LinearIndexCreator {
    private static Logger log = Logger.getLogger(LinearIndexCreator.class);
    static int DEFAULT_BINWIDTH = 16000;
    static int MILLISECONDS_IN_MINUTE = 60000;
    File featureFile;
    FeatureCodec codec;
    boolean displayProgress = true;

    public LinearIndexCreator(File featureFile, FeatureCodec codec) {
        this.featureFile = featureFile;
        this.codec = codec;
    }

    public LinearIndex createIndex() throws IOException {
        File idxFile = new File(this.featureFile.getParent(), this.featureFile.getName() + ".idx");
        return this.createIndex(idxFile, DEFAULT_BINWIDTH);
    }

    public LinearIndex createIndex(File idxFile) throws IOException {
        return this.createIndex(idxFile, DEFAULT_BINWIDTH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getHeaderLineCount() throws IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(this.featureFile);
            AsciiLineReader reader = new AsciiLineReader(is);
            int n = this.codec.readHeader(reader);
            return n;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public LinearIndex createIndex(File idxFile, int binWidth) throws IOException {
        int nHeaderLines = this.getHeaderLineCount();
        FileInputStream is = new FileInputStream(this.featureFile);
        AsciiLineReader reader = new AsciiLineReader(is);
        long fileLength = this.featureFile.length();
        long progressIncrement = fileLength / 100L;
        long currentFilePosition = 0L;
        String lastChr = null;
        int lastStart = 0;
        LinearIndex featureIndex = new LinearIndex(binWidth, this.featureFile.getAbsolutePath());
        int lastBinNumber = 0;
        int lastBinStart = -1;
        int longestFeature = 0;
        int progressCounter = 1;
        String nextLine = "";
        int lineNumber = 0;
        while (nHeaderLines-- > 0) {
            reader.readLine();
        }
        long filePosition = reader.getPosition();
        while ((nextLine = reader.readLine()) != null) {
            Feature f = this.codec.decodeLoc(nextLine);
            if (f == null) continue;
            if (lastBinStart < 0) {
                lastBinStart = f.getStart();
            }
            ++lineNumber;
            String chr = f.getChr();
            if (lastChr == null || !chr.equals(lastChr)) {
                if (lastChr != null) {
                    int bytesCount = (int)(currentFilePosition - filePosition);
                    featureIndex.add(lastChr, filePosition, bytesCount, longestFeature);
                    lastBinStart = f.getStart();
                    filePosition = currentFilePosition;
                    lastBinNumber = 0;
                    lastStart = 0;
                    longestFeature = 0;
                }
                lastChr = chr;
            } else {
                int start = f.getStart();
                longestFeature = Math.max(longestFeature, f.getEnd() - start);
                if (start < 0) {
                    System.out.println("Warning: negative start position at line: " + lineNumber + " : " + nextLine);
                    continue;
                }
                if (start < lastStart) {
                    throw new UnsortedFileException(" File must be sorted by start position. Sort test failed at: " + nextLine);
                }
                lastStart = start;
                int binNumber = start / binWidth;
                if (binNumber > lastBinNumber) {
                    int cnt = 0;
                    for (cnt = 0; cnt < lastBinStart / binWidth - lastBinNumber; ++cnt) {
                        featureIndex.add(lastChr, filePosition, 0, longestFeature);
                    }
                    lastBinNumber += cnt;
                    int bytesCount = (int)(currentFilePosition - filePosition);
                    featureIndex.add(lastChr, filePosition, bytesCount, longestFeature);
                    lastBinStart = f.getStart();
                    filePosition = currentFilePosition;
                    for (cnt = 0; cnt < binNumber - lastBinNumber - 1; ++cnt) {
                        featureIndex.add(lastChr, filePosition, 0, longestFeature);
                    }
                    lastBinNumber = binNumber;
                }
            }
            if ((currentFilePosition = reader.getPosition()) <= (long)progressCounter * progressIncrement) continue;
            this.updateProgress(progressCounter);
            ++progressCounter;
        }
        int byteCount = (int)(reader.getPosition() - filePosition);
        featureIndex.add(lastChr, filePosition, byteCount, longestFeature);
        is.close();
        if (idxFile != null) {
            featureIndex.write(idxFile);
        }
        return featureIndex;
    }

    private void updateProgress(int progressCounter) {
        log.debug((Object)("Progress: " + progressCounter + "%"));
    }
}

