/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.index.linear;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import org.apache.log4j.Logger;
import org.broad.tribble.index.Block;
import org.broad.tribble.index.Index;
import org.broad.tribble.util.LEDataInputStream;
import org.broad.tribble.util.LEDataOutputStream;

public class LinearIndex
implements Index {
    private static Logger log = Logger.getLogger(LinearIndex.class);
    public static final int CURRENT_VERSION = 2;
    private SAMSequenceDictionary sequenceDictionary;
    private int defaultBinWidth;
    private int type;
    private int version;
    String indexedFile;
    long indexedFileSize;
    long indexedFileTS;
    String indexedFileMD5 = "";
    private Map<String, ChromosomeIndex> chrIndeces;
    private static final int SEQUENCE_DICTIONARY_FLAG = 32768;

    public LinearIndex(int binWidth, String featureFile) {
        this.type = 1;
        this.version = 2;
        this.defaultBinWidth = binWidth;
        this.indexedFile = featureFile;
        this.indexedFileSize = featureFile.length();
        this.chrIndeces = new LinkedHashMap<String, ChromosomeIndex>();
    }

    public void setMD5(String md5) {
        this.indexedFileMD5 = md5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Index createIndex(File indexFile) {
        LinearIndex idx = null;
        FileInputStream is = null;
        try {
            is = new FileInputStream(indexFile);
            idx = new LinearIndex(is);
        }
        catch (IOException ex) {
            log.error((Object)("Error reading index file: " + indexFile.getAbsolutePath()), (Throwable)ex);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    log.error((Object)("Error closing indexFile: " + indexFile.getAbsolutePath()), (Throwable)e);
                }
            }
        }
        return idx;
    }

    public LinearIndex(InputStream is) throws IOException {
        this.chrIndeces = new LinkedHashMap<String, ChromosomeIndex>();
        this.read(is);
    }

    public boolean containsChromosome(String chr) {
        return this.chrIndeces.containsKey(chr);
    }

    public Set<String> getIndexedChromosomes() {
        return this.chrIndeces.keySet();
    }

    public void add(String chr, long idx, int size, int longestFeature) {
        ChromosomeIndex chrIndex = this.chrIndeces.get(chr);
        if (chrIndex == null) {
            chrIndex = new ChromosomeIndex(chr, this.defaultBinWidth);
            this.chrIndeces.put(chr, chrIndex);
        }
        chrIndex.updateLongestFeature(longestFeature);
        chrIndex.addBlock(new Block(idx, size));
    }

    @Override
    public List<Block> getChunks(String chr, int start, int end) {
        ChromosomeIndex chrIdx = this.chrIndeces.get(chr);
        if (chrIdx == null) {
            return null;
        }
        return chrIdx.getBlocks(start, end);
    }

    @Override
    public SAMSequenceDictionary getSequenceDictionary() {
        if (this.sequenceDictionary == null && this.chrIndeces != null && !this.chrIndeces.isEmpty()) {
            this.sequenceDictionary = new SAMSequenceDictionary();
            for (String name : this.chrIndeces.keySet()) {
                SAMSequenceRecord seq = new SAMSequenceRecord(name, 0);
                this.sequenceDictionary.addSequence(seq);
            }
        }
        return this.sequenceDictionary;
    }

    @Override
    public void setSequenceDictionary(SAMSequenceDictionary dictionary) {
        this.sequenceDictionary = dictionary;
    }

    @Override
    public boolean isCurrentVersion() {
        return this.version == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File f) throws IOException {
        LEDataOutputStream dos = null;
        try {
            dos = new LEDataOutputStream(new BufferedOutputStream(new FileOutputStream(f)));
            this.writeHeader(dos);
            dos.writeInt(this.chrIndeces.size());
            for (ChromosomeIndex chrIdx : this.chrIndeces.values()) {
                chrIdx.write(dos);
            }
        }
        finally {
            dos.close();
        }
    }

    private void writeHeader(LEDataOutputStream dos) throws IOException {
        int magicNumber = 1480870228;
        dos.writeInt(magicNumber);
        dos.writeInt(this.type);
        dos.writeInt(this.version);
        dos.writeString(this.indexedFile);
        dos.writeLong(this.indexedFileSize);
        dos.writeLong(this.indexedFileTS);
        dos.writeString(this.indexedFileMD5);
        dos.writeInt(32768);
        this.writeSequenceDictionary(dos);
    }

    private void writeSequenceDictionary(LEDataOutputStream dos) throws IOException {
        if (this.sequenceDictionary == null) {
            this.writeDictFromIndexInfo(dos);
        } else {
            dos.writeInt(this.sequenceDictionary.size());
            for (SAMSequenceRecord record : this.sequenceDictionary.getSequences()) {
                dos.writeString(record.getSequenceName());
                dos.writeInt(record.getSequenceLength());
            }
        }
    }

    private void writeDictFromIndexInfo(LEDataOutputStream dos) throws IOException {
        dos.writeInt(this.chrIndeces.size());
        for (Map.Entry<String, ChromosomeIndex> record : this.chrIndeces.entrySet()) {
            dos.writeString(record.getKey());
            dos.writeInt(0);
        }
    }

    private void readHeader(LEDataInputStream dis) throws IOException {
        int magicNumber = dis.readInt();
        this.type = dis.readInt();
        this.version = dis.readInt();
        this.indexedFile = dis.readString();
        this.indexedFileSize = dis.readLong();
        this.indexedFileTS = dis.readLong();
        this.indexedFileMD5 = dis.readString();
        int flags = dis.readInt();
        if ((flags & 0x8000) == 32768) {
            this.readSequenceDictionary(dis);
        }
    }

    private void readSequenceDictionary(LEDataInputStream dis) throws IOException {
        int size = dis.readInt();
        if (size < 0) {
            throw new IllegalStateException("Size of the sequence dictionary entries is negitive");
        }
        SAMSequenceDictionary dictionary = new SAMSequenceDictionary();
        for (int x = 0; x < size; ++x) {
            SAMSequenceRecord seq = new SAMSequenceRecord(dis.readString(), dis.readInt());
            dictionary.addSequence(seq);
        }
        this.sequenceDictionary = dictionary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(InputStream is) throws IOException {
        LEDataInputStream dis = null;
        try {
            dis = new LEDataInputStream(new BufferedInputStream(is));
            this.readHeader(dis);
            int nChromosomes = dis.readInt();
            this.chrIndeces = new HashMap<String, ChromosomeIndex>(nChromosomes * 2);
            while (nChromosomes-- > 0) {
                ChromosomeIndex chrIdx = new ChromosomeIndex(dis);
                this.chrIndeces.put(chrIdx.getName(), chrIdx);
            }
        }
        finally {
            dis.close();
        }
    }

    public int getLongestFeature(String chr) {
        ChromosomeIndex tmp = this.chrIndeces.get(chr);
        if (tmp == null) {
            return 1000;
        }
        return tmp.getLongestFeature();
    }

    class ChromosomeIndex {
        private String name;
        private int binWidth;
        private int longestFeature;
        private int largestBlockSize;
        private int totalBlockSize;
        private List<Block> blocks;

        ChromosomeIndex(LEDataInputStream dis) throws IOException {
            this.fill(dis);
        }

        ChromosomeIndex(String name, int binWidth) {
            this.name = name;
            this.binWidth = binWidth;
            this.blocks = new ArrayList<Block>(100);
            this.longestFeature = 0;
            this.largestBlockSize = 0;
            this.totalBlockSize = 0;
        }

        public String getName() {
            return this.name;
        }

        void addBlock(Block block) {
            this.blocks.add(block);
            this.totalBlockSize += block.getSize();
            this.largestBlockSize = Math.max(this.largestBlockSize, block.getSize());
        }

        List<Block> getBlocks(int start, int end) {
            if (this.blocks == null || this.blocks.isEmpty()) {
                return null;
            }
            int adjustedPosition = Math.max(start - this.longestFeature, 0);
            int startBinNumber = Math.min(adjustedPosition / this.binWidth, this.blocks.size() - 1);
            int endBinNumber = Math.min(end / this.binWidth, this.blocks.size() - 1);
            return this.blocks.subList(startBinNumber, endBinNumber + 1);
        }

        public int getLongestFeature() {
            return this.longestFeature;
        }

        public void updateLongestFeature(int featureLength) {
            this.longestFeature = Math.max(this.longestFeature, featureLength);
        }

        public int getLargestBlockSize() {
            return this.largestBlockSize;
        }

        public int getAverageBlockSize() {
            int n = this.blocks.size();
            return n == 0 ? 0 : this.totalBlockSize / n;
        }

        public void write(LEDataOutputStream dos) throws IOException {
            dos.writeString(this.name);
            dos.writeInt(this.binWidth);
            dos.writeInt(this.blocks.size());
            dos.writeInt(this.longestFeature);
            dos.writeInt(this.largestBlockSize);
            dos.writeInt(this.totalBlockSize);
            long pos = 0L;
            int size = 0;
            for (Block block : this.blocks) {
                pos = block.getStartPosition();
                size = block.getSize();
                dos.writeLong(pos);
            }
            dos.writeLong(pos + (long)size);
        }

        public void fill(LEDataInputStream dis) throws IOException {
            this.name = dis.readString();
            this.binWidth = dis.readInt();
            int nBins = dis.readInt();
            this.longestFeature = dis.readInt();
            this.largestBlockSize = dis.readInt();
            this.totalBlockSize = dis.readInt();
            this.blocks = new ArrayList<Block>(nBins);
            long pos = dis.readLong();
            for (int binNumber = 0; binNumber < nBins; ++binNumber) {
                long nextPos = dis.readLong();
                int size = (int)(nextPos - pos);
                this.blocks.add(new Block(pos, size));
                pos = nextPos;
            }
        }
    }
}

