/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.gelitext;

import java.util.Arrays;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.annotation.DiploidGenotype;
import org.broad.tribble.exception.CodecLineParsingException;
import org.broad.tribble.gelitext.GeliTextFeature;
import org.broad.tribble.util.LineReader;
import org.broad.tribble.util.ParsingUtils;

public class GeliTextCodec
implements FeatureCodec {
    private static String[] parts = new String[18];

    @Override
    public Feature decodeLoc(String line) {
        return this.decode(line);
    }

    public Feature decode(String line) {
        if (line.startsWith("#")) {
            return null;
        }
        int length = ParsingUtils.splitWhitespace(line, parts);
        if (length != 18) {
            throw new CodecLineParsingException("Invalid GeliTextFeature row found -- too few elements.  Expected 18, got " + length + " line = " + line);
        }
        char[] x = parts[5].toUpperCase().toCharArray();
        Arrays.sort(x);
        String bestGenotype = new String(x);
        double[] genotypeLikelihoods = new double[10];
        int pieceIndex = 8;
        int offset = 0;
        while (pieceIndex < 18) {
            genotypeLikelihoods[offset] = Double.valueOf(parts[pieceIndex]);
            ++pieceIndex;
            ++offset;
        }
        return new GeliTextFeature(parts[0], Long.valueOf(parts[1]), Character.toUpperCase(parts[2].charAt(0)), Integer.valueOf(parts[3]), Integer.valueOf(parts[4]), DiploidGenotype.toDiploidGenotype(bestGenotype), Double.valueOf(parts[6]), Double.valueOf(parts[7]), genotypeLikelihoods);
    }

    @Override
    public int readHeader(LineReader reader) {
        return 0;
    }

    public Class getFeatureType() {
        return GeliTextFeature.class;
    }

    public Object getHeader(Class clazz) throws ClassCastException {
        return null;
    }
}

