/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.gatkinterval;

import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.exception.CodecLineParsingException;
import org.broad.tribble.gatkinterval.GATKIntervalFeature;
import org.broad.tribble.util.LineReader;
import org.broad.tribble.util.ParsingUtils;

public class GATKIntervalCodec
implements FeatureCodec {
    private static String[] firstSplit = new String[2];
    private static String[] secondSplit = new String[2];

    @Override
    public Feature decodeLoc(String line) {
        return this.decode(line);
    }

    public Feature decode(String line) {
        int splitCount = ParsingUtils.split(line, firstSplit, ':');
        if (splitCount != 2) {
            throw new CodecLineParsingException("Unable to parse GATK interval file, at line = " + line);
        }
        splitCount = ParsingUtils.split(firstSplit[1], secondSplit, '-');
        if (splitCount != 2) {
            throw new CodecLineParsingException("Unable to parse GATK interval file, at line = " + line);
        }
        return new GATKIntervalFeature(firstSplit[0], Integer.valueOf(secondSplit[0]), Integer.valueOf(secondSplit[1]));
    }

    @Override
    public int readHeader(LineReader reader) {
        return 0;
    }

    public Class getFeatureType() {
        return GATKIntervalFeature.class;
    }

    public Object getHeader(Class clazz) throws ClassCastException {
        return null;
    }
}

