/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.dbsnp;

import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.annotation.Strand;
import org.broad.tribble.dbsnp.DbSNPFeature;
import org.broad.tribble.exception.CodecLineParsingException;
import org.broad.tribble.util.LineReader;

public class DbSNPCodec
implements FeatureCodec {
    static final int expectedTokenCount = 18;

    @Override
    public Feature decodeLoc(String line) {
        return this.decode(line);
    }

    public Feature decode(String line) {
        if (line.startsWith("#")) {
            return null;
        }
        String[] tokens = line.split("\\t+");
        if (tokens.length != 18) {
            throw new CodecLineParsingException("the dbSNP line didn't have the expected number of tokens (expected = 18, saw = " + tokens.length + " on " + "line = " + line + ")");
        }
        int start = Integer.valueOf(tokens[2]) + 1;
        int stop = Integer.valueOf(tokens[3]);
        stop = stop < start ? start : stop;
        DbSNPFeature feature = new DbSNPFeature(tokens[1], start, stop);
        feature.setRsID(tokens[4]);
        feature.setScore(Integer.valueOf(tokens[5]));
        feature.setStrand(tokens[6].equals("+") ? Strand.POSITIVE : Strand.NEGATIVE);
        feature.setNCBIRefBase(tokens[7]);
        feature.setUCSCRefBase(tokens[8]);
        feature.setObserved(tokens[9].split("/"));
        feature.setMolType(tokens[10]);
        feature.setVariantType(tokens[11]);
        feature.setValidationStatus(tokens[12]);
        feature.setAvHet(Double.valueOf(tokens[13]));
        feature.setAvHetSE(Double.valueOf(tokens[14]));
        feature.setFunction(tokens[15]);
        feature.setLocationType(tokens[16]);
        feature.setWeight(Integer.valueOf(tokens[17]));
        return feature;
    }

    @Override
    public int readHeader(LineReader reader) {
        return 0;
    }

    public Class getFeatureType() {
        return DbSNPFeature.class;
    }

    public Object getHeader(Class clazz) throws ClassCastException {
        return null;
    }
}

