/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.io.File;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.Log;
import net.sf.samtools.BAMFileIndexWriter;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;

public class BuildBamIndex
extends CommandLineProgram {
    @Usage
    public String USAGE = this.getStandardUsagePreamble() + "Generates a BAM index (.bai) file." + "Input BAM file must be sorted in coordinate order.";
    @Option(shortName="I", doc="A BAM file to process.")
    public File INPUT;
    @Option(shortName="O", doc="The BAM index file", optional=true)
    public File OUTPUT;
    @Option(doc="Whether to overwrite an existing bai file", shortName="OVERWRITE")
    public Boolean OVERWRITE_EXISTING_BAI_FILE = false;
    @Option(doc="Whether to sort the bins in sequence order")
    public Boolean SORT = true;
    @Option(doc="Whether to write textual or binary representation", shortName="TEXT")
    public Boolean TEXTUAL = false;

    public static void main(String[] argv) {
        System.exit(new BuildBamIndex().instanceMain(argv));
    }

    @Override
    protected int doWork() {
        Log log = Log.getInstance(this.getClass());
        int count = 0;
        IoUtil.assertFileIsReadable(this.INPUT);
        IoUtil.assertFileIsWritable(this.OUTPUT);
        log.info("Reading input file and building index.");
        try {
            SAMFileReader bam = new SAMFileReader(this.INPUT);
            bam.enableFileSource(true);
            if (!bam.getFileHeader().getSortOrder().equals((Object)SAMFileHeader.SortOrder.coordinate)) {
                throw new PicardException("Input BAM file must be sorted by coordinates");
            }
            BAMFileIndexWriter instance = new BAMFileIndexWriter(this.OUTPUT, bam.getFileHeader().getSequenceDictionary().size());
            count = instance.createIndex(this.INPUT, this.TEXTUAL.booleanValue(), this.SORT.booleanValue());
        }
        catch (Exception e) {
            log.error(e.getMessage() + " exception when writing output file " + this.OUTPUT + e);
            e.printStackTrace();
            return 1;
        }
        log.info("Successfully wrote bam index file " + this.OUTPUT + " from " + count + " records");
        return 0;
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.OUTPUT == null) {
            int lastDot;
            String baseFileName = this.INPUT.getName();
            if (baseFileName.endsWith(".bam") && (lastDot = baseFileName.lastIndexOf(46)) != -1) {
                baseFileName = baseFileName.substring(0, lastDot);
            }
            this.OUTPUT = this.TEXTUAL != false ? new File(baseFileName + ".bai" + ".txt") : new File(baseFileName + ".bai");
        }
        if (!this.OVERWRITE_EXISTING_BAI_FILE.booleanValue() && this.OUTPUT.exists()) {
            return new String[]{"Output file already exists.  Use option OVERWRITE=true to replace " + this.OUTPUT.toString()};
        }
        SAMFileReader bam = new SAMFileReader(this.INPUT);
        if (!bam.isBinary()) {
            return new String[]{"Input file must be bam file, not sam file"};
        }
        return null;
    }
}

