/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.io.File;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.Log;
import net.sf.samtools.BAMIndexTextWriter;

public class BaiToText
extends CommandLineProgram {
    @Usage
    public String USAGE = this.getStandardUsagePreamble() + "Generates a textual form of a BAM index (.bai) file.";
    @Option(shortName="I", doc="A BAM Index file to process.")
    public File INPUT;
    @Option(shortName="O", doc="The textual BAM index file output", optional=true)
    public File OUTPUT;
    @Option(doc="Whether to overwrite an existing bai.txt file", shortName="OVERWRITE")
    public Boolean OVERWRITE_EXISTING_BAI_FILE = false;
    @Option(doc="Whether to sort the bins in sequence order")
    public Boolean SORT = true;
    @Option(doc="Whether to write textual or binary representation", shortName="TEXT")
    public Boolean TEXTUAL = true;

    public static void main(String[] argv) {
        System.exit(new BaiToText().instanceMain(argv));
    }

    @Override
    protected int doWork() {
        Log log = Log.getInstance(this.getClass());
        IoUtil.assertFileIsReadable(this.INPUT);
        IoUtil.assertFileIsWritable(this.OUTPUT);
        log.info("Reading input file and building index.");
        try {
            BAMIndexTextWriter instance = new BAMIndexTextWriter(this.INPUT, this.OUTPUT);
            if (this.TEXTUAL.booleanValue()) {
                instance.writeText(this.SORT.booleanValue());
            } else {
                instance.writeBinary(this.SORT.booleanValue(), 0L);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage() + " exception when writing output file " + this.OUTPUT + e);
            e.printStackTrace();
            return 1;
        }
        log.info("Successfully wrote bam index file " + this.OUTPUT);
        return 0;
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.OUTPUT == null) {
            this.OUTPUT = this.TEXTUAL != false ? new File(this.INPUT.getName() + ".txt") : new File(this.INPUT.getName() + ".bai");
        }
        if (!this.OVERWRITE_EXISTING_BAI_FILE.booleanValue() && this.OUTPUT.exists()) {
            return new String[]{"Output file already exists.  Use option OVERWRITE=true to replace " + this.OUTPUT.toString()};
        }
        return null;
    }
}

