/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import java.util.HashMap;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.fastq.FastqRecord;
import net.sf.picard.fastq.FastqWriter;
import net.sf.picard.io.IoUtil;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMUtils;
import net.sf.samtools.util.SequenceUtil;
import net.sf.samtools.util.StringUtil;

public class SamToFastq
extends CommandLineProgram {
    @Usage
    public String USAGE = "Extracts read sequences and qualities from the input SAM/BAM file and writes them into the output file in Sanger fastq format. In the RC mode (default is True), if the read is aligned and the alignment is to the reverse strand on the genome, the read's sequence from input SAM file will be reverse-complemented prior to writing it to fastq in order restore correctly the original read sequence as it was generated by the sequencer.";
    @Option(doc="Input SAM/BAM file to extract reads from", shortName="I")
    public File INPUT;
    @Option(shortName="F", doc="Output fastq file (single-end fastq or, if paired, first end of the pair fastq).")
    public File FASTQ;
    @Option(shortName="F2", doc="Output fastq file (if paired, second end of the pair fastq).", optional=true)
    public File SECOND_END_FASTQ;
    @Option(shortName="RC", doc="Re-reverse bases and qualities of reads with negative strand flag set before writing them to fastq", optional=true)
    public Boolean RE_REVERSE = true;
    @Option(shortName="NON_PF", doc="Include non-PF reads from the SAM file into the output FASTQ files.")
    public boolean INCLUDE_NON_PF_READS = false;
    @Option(shortName="CLIP_ATTR", doc="The attribute that stores the position at which the SAM record should be clipped", optional=true)
    public String CLIPPING_ATTRIBUTE;
    @Option(shortName="CLIP_ACT", doc="The action that should be taken with clipped reads: 'X' means the reads and qualities should be trimmed at the clipped position; 'N' means the bases should be changed to Ns in the clipped region; and any integer means that the base qualities should be set to that value in the clipped region.", optional=true)
    public String CLIPPING_ACTION;

    public static void main(String[] argv) {
        System.exit(new SamToFastq().instanceMain(argv));
    }

    @Override
    protected int doWork() {
        if (this.SECOND_END_FASTQ == null) {
            this.doUnpaired();
        } else {
            this.doPaired();
        }
        return 0;
    }

    protected void doUnpaired() {
        IoUtil.assertFileIsReadable(this.INPUT);
        IoUtil.assertFileIsWritable(this.FASTQ);
        SAMFileReader reader = new SAMFileReader(IoUtil.openFileForReading(this.INPUT));
        FastqWriter writer = new FastqWriter(this.FASTQ);
        for (SAMRecord record : reader) {
            if (record.getReadFailsVendorQualityCheckFlag() && !this.INCLUDE_NON_PF_READS) continue;
            this.writeRecord(record, null, writer);
        }
        reader.close();
        writer.close();
    }

    protected void doPaired() {
        IoUtil.assertFileIsReadable(this.INPUT);
        IoUtil.assertFileIsWritable(this.FASTQ);
        IoUtil.assertFileIsWritable(this.SECOND_END_FASTQ);
        SAMFileReader reader = new SAMFileReader(IoUtil.openFileForReading(this.INPUT));
        FastqWriter writer1 = new FastqWriter(this.FASTQ);
        FastqWriter writer2 = new FastqWriter(this.SECOND_END_FASTQ);
        HashMap<String, SAMRecord> firstSeenMates = new HashMap<String, SAMRecord>();
        for (SAMRecord currentRecord : reader) {
            if (currentRecord.getReadFailsVendorQualityCheckFlag() && !this.INCLUDE_NON_PF_READS) continue;
            String currentReadName = currentRecord.getReadName();
            SAMRecord firstRecord = (SAMRecord)firstSeenMates.get(currentReadName);
            if (firstRecord == null) {
                firstSeenMates.put(currentReadName, currentRecord);
                continue;
            }
            this.assertPairedMates(firstRecord, currentRecord);
            if (currentRecord.getFirstOfPairFlag()) {
                this.writeRecord(currentRecord, 1, writer1);
                this.writeRecord(firstRecord, 2, writer2);
            } else {
                this.writeRecord(firstRecord, 1, writer1);
                this.writeRecord(currentRecord, 2, writer2);
            }
            firstSeenMates.remove(currentReadName);
        }
        if (firstSeenMates.size() > 0) {
            throw new PicardException("Found " + firstSeenMates.size() + " unpaired mates");
        }
        reader.close();
        writer1.close();
        writer2.close();
    }

    void writeRecord(SAMRecord read, Integer mateNumber, FastqWriter writer) {
        Integer clipPoint;
        String seqHeader = mateNumber == null ? read.getReadName() : read.getReadName() + "/" + mateNumber;
        String readString = read.getReadString();
        String baseQualities = read.getBaseQualityString();
        if (this.CLIPPING_ATTRIBUTE != null && (clipPoint = (Integer)read.getAttribute(this.CLIPPING_ATTRIBUTE)) != null) {
            if (this.CLIPPING_ACTION.equalsIgnoreCase("X")) {
                readString = this.clip(readString, clipPoint, null, !read.getReadNegativeStrandFlag());
                baseQualities = this.clip(baseQualities, clipPoint, null, !read.getReadNegativeStrandFlag());
            } else if (this.CLIPPING_ACTION.equalsIgnoreCase("N")) {
                readString = this.clip(readString, clipPoint, Character.valueOf('N'), !read.getReadNegativeStrandFlag());
            } else {
                char newQual = SAMUtils.phredToFastq((byte[])new byte[]{(byte)Integer.parseInt(this.CLIPPING_ACTION)}).charAt(0);
                baseQualities = this.clip(baseQualities, clipPoint, Character.valueOf(newQual), !read.getReadNegativeStrandFlag());
            }
        }
        if (this.RE_REVERSE.booleanValue() && read.getReadNegativeStrandFlag()) {
            readString = SequenceUtil.reverseComplement((String)readString);
            baseQualities = StringUtil.reverseString((String)baseQualities);
        }
        writer.write(new FastqRecord(seqHeader, readString, "", baseQualities));
    }

    private String clip(String src, int point, Character replacement, boolean posStrand) {
        String result;
        block4: {
            int len = src.length();
            String string = result = posStrand ? src.substring(0, point - 1) : src.substring(len - point + 1);
            if (replacement == null) break block4;
            if (posStrand) {
                for (int i = point; i <= len; ++i) {
                    result = result + replacement;
                }
            } else {
                for (int i = 0; i <= len - point; ++i) {
                    result = replacement + result;
                }
            }
        }
        return result;
    }

    private void assertPairedMates(SAMRecord record1, SAMRecord record2) {
        if (!(record1.getFirstOfPairFlag() && record2.getSecondOfPairFlag() || record2.getFirstOfPairFlag() && record1.getSecondOfPairFlag())) {
            throw new PicardException("Illegal mate state: " + record1.getReadName());
        }
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.CLIPPING_ATTRIBUTE != null && this.CLIPPING_ACTION == null || this.CLIPPING_ATTRIBUTE == null && this.CLIPPING_ACTION != null) {
            return new String[]{"Both or neither of CLIPPING_ATTRIBUTE and CLIPPING_ACTION should be set."};
        }
        if (this.CLIPPING_ACTION != null && !this.CLIPPING_ACTION.equals("N") && !this.CLIPPING_ACTION.equals("X")) {
            try {
                Integer.parseInt(this.CLIPPING_ACTION);
            }
            catch (NumberFormatException nfe) {
                return new String[]{"CLIPPING ACTION must be one of: N, X, or an integer"};
            }
        }
        return null;
    }
}

