/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;

public class SamFormatConverter
extends CommandLineProgram {
    private static final String PROGRAM_VERSION = "1.0";
    @Usage
    public String USAGE = this.getStandardUsagePreamble() + "Convert a BAM file to a SAM file, or BAM to SAM.\n" + "" + "Input and output formats are determined by file extension.";
    @Option(doc="The BAM or SAM file to parse.", shortName="I")
    public File INPUT;
    @Option(doc="The BAM or SAM output file. ", shortName="O")
    public File OUTPUT;

    @Override
    protected int doWork() {
        IoUtil.assertFileIsReadable(this.INPUT);
        IoUtil.assertFileIsWritable(this.OUTPUT);
        SAMFileReader reader = new SAMFileReader(IoUtil.openFileForReading(this.INPUT));
        SAMFileWriter writer = new SAMFileWriterFactory().makeSAMOrBAMWriter(reader.getFileHeader(), true, this.OUTPUT);
        SAMRecordIterator iterator = reader.iterator();
        while (iterator.hasNext()) {
            writer.addAlignment((SAMRecord)iterator.next());
        }
        reader.close();
        writer.close();
        return 0;
    }

    public static void main(String[] argv) {
        System.exit(new SamFormatConverter().instanceMain(argv));
    }
}

