/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.picard.PicardException;
import net.sf.samtools.AbstractSAMHeaderRecord;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMProgramRecord;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.util.SequenceUtil;

public class SamFileHeaderMerger {
    private final SAMFileHeader mergedHeader;
    private final Collection<SAMFileReader> readers;
    private final Map<SAMFileReader, Map<String, String>> samReadGroupIdTranslation = new HashMap<SAMFileReader, Map<String, String>>();
    private boolean hasReadGroupCollisions = false;
    private boolean hasProgramGroupCollisions = false;
    private Map<SAMFileReader, Map<String, String>> samProgramGroupIdTranslation = new HashMap<SAMFileReader, Map<String, String>>();
    private boolean hasMergedSequenceDictionary = false;
    private final Map<SAMFileReader, Map<Integer, Integer>> samSeqDictionaryIdTranslation = new HashMap<SAMFileReader, Map<Integer, Integer>>();
    private final Map<SAMFileHeader, Map<Integer, Integer>> samSeqDictionaryIdTranslationViaHeader = new IdentityHashMap<SAMFileHeader, Map<Integer, Integer>>();
    private static final HeaderRecordFactory<SAMReadGroupRecord> READ_GROUP_RECORD_FACTORY = new HeaderRecordFactory<SAMReadGroupRecord>(){

        @Override
        public SAMReadGroupRecord createRecord(String id, SAMReadGroupRecord srcReadGroupRecord) {
            return new SAMReadGroupRecord(id, srcReadGroupRecord);
        }
    };
    private static final HeaderRecordFactory<SAMProgramRecord> PROGRAM_RECORD_FACTORY = new HeaderRecordFactory<SAMProgramRecord>(){

        @Override
        public SAMProgramRecord createRecord(String id, SAMProgramRecord srcProgramRecord) {
            return new SAMProgramRecord(id, srcProgramRecord);
        }
    };
    private static final Comparator<AbstractSAMHeaderRecord> RECORD_ID_COMPARATOR = new Comparator<AbstractSAMHeaderRecord>(){

        @Override
        public int compare(AbstractSAMHeaderRecord o1, AbstractSAMHeaderRecord o2) {
            return o1.getId().compareTo(o2.getId());
        }
    };

    public SamFileHeaderMerger(Collection<SAMFileReader> readers, SAMFileHeader.SortOrder sortOrder) {
        this(readers, sortOrder, false);
    }

    public SamFileHeaderMerger(Collection<SAMFileReader> readers, SAMFileHeader.SortOrder sortOrder, boolean mergeDictionaries) {
        SAMSequenceDictionary sequenceDictionary;
        this.readers = readers;
        this.mergedHeader = new SAMFileHeader();
        try {
            sequenceDictionary = this.getSequenceDictionary(readers);
            this.hasMergedSequenceDictionary = false;
        }
        catch (SequenceUtil.SequenceListsDifferException pe) {
            if (mergeDictionaries) {
                sequenceDictionary = this.mergeSequenceDictionaries(readers);
                this.hasMergedSequenceDictionary = true;
            }
            throw pe;
        }
        this.mergedHeader.setSequenceDictionary(sequenceDictionary);
        for (SAMProgramRecord program : this.mergeProgramGroups(readers)) {
            this.mergedHeader.addProgramRecord(program);
        }
        List<SAMReadGroupRecord> readGroups = this.mergeReadGroups(readers);
        this.mergedHeader.setReadGroups(readGroups);
        this.mergedHeader.setGroupOrder(SAMFileHeader.GroupOrder.none);
        this.mergedHeader.setSortOrder(sortOrder);
        for (SAMFileReader reader : readers) {
            for (String comment : reader.getFileHeader().getComments()) {
                this.mergedHeader.addComment(comment);
            }
        }
    }

    private List<SAMReadGroupRecord> mergeReadGroups(Collection<SAMFileReader> readers) {
        HashSet<String> idsThatAreAlreadyTaken = new HashSet<String>();
        LinkedList readGroupsToProcess = new LinkedList();
        for (SAMFileReader reader : readers) {
            for (SAMReadGroupRecord readGroup : reader.getFileHeader().getReadGroups()) {
                if (!idsThatAreAlreadyTaken.add(readGroup.getId())) {
                    throw new PicardException("Input file: " + reader + " contains more than one RG with the same id (" + readGroup.getId() + ")");
                }
                readGroupsToProcess.add(new HeaderRecordAndFileReader<SAMReadGroupRecord>(readGroup, reader));
            }
            idsThatAreAlreadyTaken.clear();
        }
        LinkedList<SAMReadGroupRecord> result = new LinkedList<SAMReadGroupRecord>();
        this.hasReadGroupCollisions = this.mergeHeaderRecords(readGroupsToProcess, READ_GROUP_RECORD_FACTORY, idsThatAreAlreadyTaken, this.samReadGroupIdTranslation, result);
        Collections.sort(result, RECORD_ID_COMPARATOR);
        return result;
    }

    private List<SAMProgramRecord> mergeProgramGroups(Collection<SAMFileReader> readers) {
        LinkedList<SAMProgramRecord> overallResult = new LinkedList<SAMProgramRecord>();
        HashSet<String> idsThatAreAlreadyTaken = new HashSet<String>();
        List<HeaderRecordAndFileReader<SAMProgramRecord>> programGroupsLeftToProcess = new LinkedList<HeaderRecordAndFileReader<SAMProgramRecord>>();
        for (SAMFileReader reader : readers) {
            for (SAMProgramRecord sAMProgramRecord : reader.getFileHeader().getProgramRecords()) {
                if (!idsThatAreAlreadyTaken.add(sAMProgramRecord.getId())) {
                    throw new PicardException("Input file: " + reader + " contains more than one PG with the same id (" + sAMProgramRecord.getId() + ")");
                }
                programGroupsLeftToProcess.add(new HeaderRecordAndFileReader<SAMProgramRecord>(sAMProgramRecord, reader));
            }
            idsThatAreAlreadyTaken.clear();
        }
        List<HeaderRecordAndFileReader<Object>> currentProgramGroups = new LinkedList<HeaderRecordAndFileReader<SAMProgramRecord>>();
        Iterator programGroupsLeftToProcessIterator = programGroupsLeftToProcess.iterator();
        while (programGroupsLeftToProcessIterator.hasNext()) {
            HeaderRecordAndFileReader pair = (HeaderRecordAndFileReader)programGroupsLeftToProcessIterator.next();
            if (((SAMProgramRecord)pair.getHeaderRecord()).getAttribute("PP") != null) continue;
            programGroupsLeftToProcessIterator.remove();
            currentProgramGroups.add(pair);
        }
        while (!currentProgramGroups.isEmpty()) {
            LinkedList currentResult = new LinkedList();
            this.hasProgramGroupCollisions |= this.mergeHeaderRecords(currentProgramGroups, PROGRAM_RECORD_FACTORY, idsThatAreAlreadyTaken, this.samProgramGroupIdTranslation, currentResult);
            overallResult.addAll(currentResult);
            currentProgramGroups = this.translateIds(currentProgramGroups, this.samProgramGroupIdTranslation, false);
            programGroupsLeftToProcess = this.translateIds(programGroupsLeftToProcess, this.samProgramGroupIdTranslation, true);
            LinkedList<HeaderRecordAndFileReader<SAMProgramRecord>> programGroupsToProcessNext = new LinkedList<HeaderRecordAndFileReader<SAMProgramRecord>>();
            Iterator<HeaderRecordAndFileReader<SAMProgramRecord>> iterator = programGroupsLeftToProcess.iterator();
            block4: while (iterator.hasNext()) {
                HeaderRecordAndFileReader<SAMProgramRecord> pairLeftToProcess = iterator.next();
                Object ppIdOfRecordLeftToProcess = pairLeftToProcess.getHeaderRecord().getAttribute("PP");
                for (HeaderRecordAndFileReader<Object> justProcessedPair : currentProgramGroups) {
                    String idJustProcessed = ((SAMProgramRecord)justProcessedPair.getHeaderRecord()).getId();
                    if (pairLeftToProcess.getFileReader() != justProcessedPair.getFileReader() || !ppIdOfRecordLeftToProcess.equals(idJustProcessed)) continue;
                    iterator.remove();
                    programGroupsToProcessNext.add(pairLeftToProcess);
                    continue block4;
                }
            }
            currentProgramGroups = programGroupsToProcessNext;
        }
        if (!programGroupsLeftToProcess.isEmpty()) {
            StringBuffer errorMsg = new StringBuffer(programGroupsLeftToProcess.size() + " program groups weren't processed. Do their PP ids point to existing PGs? \n");
            for (HeaderRecordAndFileReader headerRecordAndFileReader : programGroupsLeftToProcess) {
                SAMProgramRecord record = (SAMProgramRecord)headerRecordAndFileReader.getHeaderRecord();
                errorMsg.append("@PG ID:" + record.getProgramGroupId() + " PN:" + record.getProgramName() + " PP:" + record.getPreviousProgramGroupId() + "\n");
            }
            throw new PicardException(errorMsg.toString());
        }
        Collections.sort(overallResult, RECORD_ID_COMPARATOR);
        return overallResult;
    }

    private List<HeaderRecordAndFileReader<SAMProgramRecord>> translateIds(List<HeaderRecordAndFileReader<SAMProgramRecord>> programGroups, Map<SAMFileReader, Map<String, String>> idTranslationTable, boolean translatePpIds) {
        LinkedList<HeaderRecordAndFileReader<SAMProgramRecord>> result = new LinkedList<HeaderRecordAndFileReader<SAMProgramRecord>>();
        for (HeaderRecordAndFileReader<SAMProgramRecord> pair : programGroups) {
            SAMProgramRecord record = pair.getHeaderRecord();
            String id = record.getProgramGroupId();
            String ppId = (String)record.getAttribute("PP");
            SAMFileReader reader = pair.getFileReader();
            Map<String, String> translations = idTranslationTable.get(reader);
            SAMProgramRecord translatedRecord = null;
            if (translations != null) {
                boolean needToTranslatePpId;
                String translatedId = translations.get(id);
                String translatedPpId = translatePpIds ? translations.get(ppId) : null;
                boolean needToTranslateId = translatedId != null && !translatedId.equals(id);
                boolean bl = needToTranslatePpId = translatedPpId != null && !translatedPpId.equals(ppId);
                if (needToTranslateId && needToTranslatePpId) {
                    translatedRecord = new SAMProgramRecord(translatedId, record);
                    translatedRecord.setAttribute("PP", (Object)translatedPpId);
                } else if (needToTranslateId) {
                    translatedRecord = new SAMProgramRecord(translatedId, record);
                } else if (needToTranslatePpId) {
                    translatedRecord = new SAMProgramRecord(id, record);
                    translatedRecord.setAttribute("PP", (Object)translatedPpId);
                }
            }
            if (translatedRecord != null) {
                result.add(new HeaderRecordAndFileReader<Object>(translatedRecord, reader));
                continue;
            }
            result.add(pair);
        }
        return result;
    }

    private <RecordType extends AbstractSAMHeaderRecord> boolean mergeHeaderRecords(List<HeaderRecordAndFileReader<RecordType>> headerRecords, HeaderRecordFactory<RecordType> headerRecordFactory, HashSet<String> idsThatAreAlreadyTaken, Map<SAMFileReader, Map<String, String>> idTranslationTable, List<RecordType> result) {
        HashMap idToRecord = new HashMap();
        for (HeaderRecordAndFileReader<RecordType> pair : headerRecords) {
            LinkedList<SAMFileReader> fileReaders;
            RecordType record = pair.getHeaderRecord();
            SAMFileReader reader = pair.getFileReader();
            String recordId = record.getId();
            LinkedHashMap<RecordType, LinkedList<SAMFileReader>> recordsWithSameId = (LinkedHashMap<RecordType, LinkedList<SAMFileReader>>)idToRecord.get(recordId);
            if (recordsWithSameId == null) {
                recordsWithSameId = new LinkedHashMap<RecordType, LinkedList<SAMFileReader>>();
                idToRecord.put(recordId, recordsWithSameId);
            }
            if ((fileReaders = (LinkedList<SAMFileReader>)recordsWithSameId.get(record)) == null) {
                fileReaders = new LinkedList<SAMFileReader>();
                recordsWithSameId.put(record, fileReaders);
            }
            fileReaders.add(reader);
        }
        boolean hasCollisions = false;
        for (Map.Entry entry : idToRecord.entrySet()) {
            String recordId = (String)entry.getKey();
            Map recordsWithSameId = (Map)entry.getValue();
            for (Map.Entry recordWithUniqueAttr : recordsWithSameId.entrySet()) {
                String newId;
                AbstractSAMHeaderRecord record = (AbstractSAMHeaderRecord)recordWithUniqueAttr.getKey();
                List fileReaders = (List)recordWithUniqueAttr.getValue();
                if (!idsThatAreAlreadyTaken.contains(recordId)) {
                    newId = recordId;
                    idsThatAreAlreadyTaken.add(recordId);
                } else {
                    hasCollisions = true;
                    int idx = 1;
                    while (idsThatAreAlreadyTaken.contains(newId = recordId + "." + Integer.toString(idx++))) {
                    }
                    idsThatAreAlreadyTaken.add(newId);
                }
                for (SAMFileReader fileReader : fileReaders) {
                    Map<String, String> readerTranslationTable = idTranslationTable.get(fileReader);
                    if (readerTranslationTable == null) {
                        readerTranslationTable = new HashMap<String, String>();
                        idTranslationTable.put(fileReader, readerTranslationTable);
                    }
                    readerTranslationTable.put(recordId, newId);
                }
                result.add(headerRecordFactory.createRecord(newId, record));
            }
        }
        return hasCollisions;
    }

    private SAMSequenceDictionary getSequenceDictionary(Collection<SAMFileReader> readers) {
        SAMSequenceDictionary sequences = null;
        for (SAMFileReader reader : readers) {
            SAMFileHeader header = reader.getFileHeader();
            if (sequences == null) {
                sequences = header.getSequenceDictionary();
                continue;
            }
            SAMSequenceDictionary currentSequences = header.getSequenceDictionary();
            SequenceUtil.assertSequenceDictionariesEqual((SAMSequenceDictionary)sequences, (SAMSequenceDictionary)currentSequences);
        }
        return sequences;
    }

    private SAMSequenceDictionary mergeSequenceDictionaries(Collection<SAMFileReader> readers) {
        SAMSequenceDictionary sequences = new SAMSequenceDictionary();
        for (SAMFileReader reader : readers) {
            SAMSequenceDictionary currentSequences = reader.getFileHeader().getSequenceDictionary();
            sequences = this.mergeSequences(sequences, currentSequences);
        }
        this.createSequenceMapping(readers, sequences);
        return sequences;
    }

    private SAMSequenceDictionary mergeSequences(SAMSequenceDictionary mergeIntoDict, SAMSequenceDictionary mergeFromDict) {
        LinkedList<SAMSequenceRecord> holder = new LinkedList<SAMSequenceRecord>();
        LinkedList<SAMSequenceRecord> resultingDict = new LinkedList<SAMSequenceRecord>();
        for (SAMSequenceRecord sequenceRecord : mergeIntoDict.getSequences()) {
            resultingDict.add(sequenceRecord);
        }
        int prevloc = -1;
        SAMSequenceRecord previouslyMerged = null;
        for (SAMSequenceRecord sequenceRecord : mergeFromDict.getSequences()) {
            int loc = SamFileHeaderMerger.getIndexOfSequenceName(resultingDict, sequenceRecord.getSequenceName());
            if (loc == -1) {
                holder.add(sequenceRecord.clone());
                continue;
            }
            if (prevloc > loc) {
                throw new PicardException("Cannot merge sequence dictionaries because sequence " + sequenceRecord.getSequenceName() + " and " + previouslyMerged.getSequenceName() + " are in different orders in two input sequence dictionaries.");
            }
            resultingDict.addAll(loc, holder);
            prevloc = loc + holder.size();
            previouslyMerged = sequenceRecord;
            holder.clear();
        }
        if (holder.size() != 0) {
            resultingDict.addAll(holder);
        }
        return new SAMSequenceDictionary(resultingDict);
    }

    private static int getIndexOfSequenceName(List<SAMSequenceRecord> list, String sequenceName) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getSequenceName().equals(sequenceName)) continue;
            return i;
        }
        return -1;
    }

    private void createSequenceMapping(Collection<SAMFileReader> readers, SAMSequenceDictionary masterDictionary) {
        LinkedList<String> resultingDictStr = new LinkedList<String>();
        for (SAMSequenceRecord r : masterDictionary.getSequences()) {
            resultingDictStr.add(r.getSequenceName());
        }
        for (SAMFileReader reader : readers) {
            HashMap<Integer, Integer> seqMap = new HashMap<Integer, Integer>();
            SAMSequenceDictionary dict = reader.getFileHeader().getSequenceDictionary();
            for (SAMSequenceRecord rec : dict.getSequences()) {
                seqMap.put(rec.getSequenceIndex(), resultingDictStr.indexOf(rec.getSequenceName()));
            }
            this.samSeqDictionaryIdTranslation.put(reader, seqMap);
            this.samSeqDictionaryIdTranslationViaHeader.put(reader.getFileHeader(), seqMap);
        }
    }

    public String getReadGroupId(SAMFileReader reader, String originalReadGroupId) {
        return this.samReadGroupIdTranslation.get(reader).get(originalReadGroupId);
    }

    public String getProgramGroupId(SAMFileReader reader, String originalProgramGroupId) {
        return this.samProgramGroupIdTranslation.get(reader).get(originalProgramGroupId);
    }

    public boolean hasReadGroupCollisions() {
        return this.hasReadGroupCollisions;
    }

    public boolean hasProgramGroupCollisions() {
        return this.hasProgramGroupCollisions;
    }

    public boolean hasMergedSequenceDictionary() {
        return this.hasMergedSequenceDictionary;
    }

    public SAMFileHeader getMergedHeader() {
        return this.mergedHeader;
    }

    public Collection<SAMFileReader> getReaders() {
        return this.readers;
    }

    public Integer getMergedSequenceIndex(SAMFileReader reader, Integer oldReferenceSequenceIndex) {
        Map<Integer, Integer> mapping = this.samSeqDictionaryIdTranslation.get(reader);
        if (mapping == null) {
            throw new PicardException("No sequence dictionary mapping available for reader: " + reader);
        }
        Integer newIndex = mapping.get(oldReferenceSequenceIndex);
        if (newIndex == null) {
            throw new PicardException("No mapping for reference index " + oldReferenceSequenceIndex + " from reader: " + reader);
        }
        return newIndex;
    }

    public Integer getMergedSequenceIndex(SAMFileHeader header, Integer oldReferenceSequenceIndex) {
        Map<Integer, Integer> mapping = this.samSeqDictionaryIdTranslationViaHeader.get(header);
        if (mapping == null) {
            throw new PicardException("No sequence dictionary mapping available for header: " + header);
        }
        Integer newIndex = mapping.get(oldReferenceSequenceIndex);
        if (newIndex == null) {
            throw new PicardException("No mapping for reference index " + oldReferenceSequenceIndex + " from header: " + header);
        }
        return newIndex;
    }

    private static class HeaderRecordAndFileReader<RecordType extends AbstractSAMHeaderRecord> {
        private RecordType headerRecord;
        private SAMFileReader samFileReader;

        public HeaderRecordAndFileReader(RecordType headerRecord, SAMFileReader samFileReader) {
            this.headerRecord = headerRecord;
            this.samFileReader = samFileReader;
        }

        public RecordType getHeaderRecord() {
            return this.headerRecord;
        }

        public SAMFileReader getFileReader() {
            return this.samFileReader;
        }
    }

    private static interface HeaderRecordFactory<RecordType extends AbstractSAMHeaderRecord> {
        public RecordType createRecord(String var1, RecordType var2);
    }
}

