/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import java.util.Comparator;
import java.util.HashMap;
import net.sf.picard.PicardException;
import net.sf.picard.io.IoUtil;
import net.sf.picard.sam.AbstractAlignmentMerger;
import net.sf.picard.sam.CigarClippingIterator;
import net.sf.picard.sam.SamPairUtil;
import net.sf.picard.util.Log;
import net.sf.samtools.BAMRecordCodec;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMProgramRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordQueryNameComparator;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.SortingCollection;

public class SamAlignmentMerger
extends AbstractAlignmentMerger {
    private final Log log = Log.getInstance(SamAlignmentMerger.class);
    private final File alignedSamFile;
    private final boolean pairedRun;
    private final int maxGaps;
    private final SAMFileReader reader;

    public SamAlignmentMerger(File unmappedBamFile, File targetBamFile, File referenceFasta, SAMProgramRecord programRecord, boolean clipAdapters, boolean bisulfiteSequence, boolean pairedRun, boolean jumpingLibrary, boolean alignedReadsOnly, File alignedSamFile, int maxGaps) {
        super(unmappedBamFile, targetBamFile, referenceFasta, clipAdapters, bisulfiteSequence, jumpingLibrary, alignedReadsOnly, programRecord);
        IoUtil.assertFileIsReadable(alignedSamFile);
        this.alignedSamFile = alignedSamFile;
        this.pairedRun = pairedRun;
        this.maxGaps = maxGaps;
        this.reader = new SAMFileReader(this.alignedSamFile);
        this.reader.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
        if (programRecord == null && this.reader.getFileHeader().getProgramRecords().size() == 1) {
            this.setProgramRecord((SAMProgramRecord)this.reader.getFileHeader().getProgramRecords().get(0));
        }
        this.log.info("Processing SAM file: " + alignedSamFile.getAbsolutePath());
    }

    @Override
    protected CloseableIterator<SAMRecord> getQuerynameSortedAlignedRecords() {
        SAMFileHeader header = new SAMFileHeader();
        header.setSortOrder(SAMFileHeader.SortOrder.queryname);
        header.setSequenceDictionary(this.getSequenceDictionary());
        if (this.getProgramRecord() != null) {
            header.addProgramRecord(this.getProgramRecord());
        }
        SortingCollection alignmentSorter = SortingCollection.newInstance(SAMRecord.class, (SortingCollection.Codec)new BAMRecordCodec(header), (Comparator)new SAMRecordQueryNameComparator(), (int)500000);
        HashMap<String, SAMRecord> readNameToReadPending = new HashMap<String, SAMRecord>();
        int count = 0;
        CigarClippingIterator it = new CigarClippingIterator((CloseableIterator<SAMRecord>)this.reader.iterator());
        while (it.hasNext()) {
            SAMRecord sam = (SAMRecord)it.next();
            sam.setReadName(this.cleanReadName(sam.getReadName()));
            if (this.pairedRun) {
                SAMRecord mate = (SAMRecord)readNameToReadPending.remove(sam.getReadName());
                if (mate != null) {
                    if (!sam.getReadUnmappedFlag() || !mate.getReadUnmappedFlag()) {
                        boolean proper = SamPairUtil.isProperPair(sam, mate, this.isJumpingLibrary());
                        sam.setProperPairFlag(proper);
                        mate.setProperPairFlag(proper);
                        SamPairUtil.setMateInfo(sam, mate, this.getHeader());
                        alignmentSorter.add((Object)sam);
                        alignmentSorter.add((Object)mate);
                        count += 2;
                    }
                } else {
                    readNameToReadPending.put(sam.getReadName(), sam);
                }
            } else if (!sam.getReadUnmappedFlag()) {
                alignmentSorter.add((Object)sam);
                ++count;
            }
            if (count <= 0 || count % 1000000 != 0) continue;
            this.log.info("Read " + count + " records from alignment SAM/BAM.");
        }
        this.log.info("Finished reading " + count + " total records from alignment SAM/BAM.");
        if (readNameToReadPending.size() > 0) {
            throw new PicardException("Unmatched reads left in pending map.");
        }
        this.reader.close();
        return alignmentSorter.iterator();
    }

    @Override
    protected boolean ignoreAlignment(SAMRecord sam) {
        int gaps = 0;
        for (CigarElement el : sam.getCigar().getCigarElements()) {
            if (el.getOperator() != CigarOperator.I && el.getOperator() != CigarOperator.D && el.getOperator() != CigarOperator.N) continue;
            ++gaps;
        }
        return gaps > this.maxGaps;
    }
}

