/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordUtil;

public class RevertSam
extends CommandLineProgram {
    @Usage
    public String USAGE = this.getStandardUsagePreamble() + "Reverts SAM or BAM files to a previous state by removing certain types of information and/or " + "substituting in the original quality scores when available.";
    @Option(shortName="I", doc="The input SAM/BAM file to revert the state of.")
    public File INPUT;
    @Option(shortName="O", doc="The output SAM/BAM file to create.")
    public File OUTPUT;
    @Option(shortName="SO", doc="The sort order to create the reverted output file with.")
    public SAMFileHeader.SortOrder SORT_ORDER = SAMFileHeader.SortOrder.queryname;
    @Option(shortName="OQ", doc="True to restore original qualities from the OQ field to the QUAL field if available.")
    public boolean RESTORE_ORIGINAL_QUALITIES = true;
    @Option(doc="Remove duplicate read flags from all reads")
    public boolean REMOVE_DUPLICATE_INFORMATION = true;
    @Option(doc="Remove all alignment information from the file.")
    public boolean REMOVE_ALIGNMENT_INFORMATION = true;
    @Option(doc="When removing alignment information, the set of optional tags to remove.")
    public List<String> ATTRIBUTE_TO_CLEAR = new ArrayList<String>(){
        {
            this.add("NM");
            this.add("UQ");
            this.add("PG");
            this.add("MD");
            this.add("MQ");
        }
    };

    public static void main(String[] args) {
        System.exit(new RevertSam().instanceMain(args));
    }

    @Override
    protected int doWork() {
        IoUtil.assertFileIsReadable(this.INPUT);
        IoUtil.assertFileIsWritable(this.OUTPUT);
        SAMFileReader in = new SAMFileReader(this.INPUT, true);
        SAMFileHeader inHeader = in.getFileHeader();
        boolean presorted = inHeader.getSortOrder() == this.SORT_ORDER;
        SAMFileHeader outHeader = new SAMFileHeader();
        outHeader.setReadGroups(inHeader.getReadGroups());
        outHeader.setSortOrder(this.SORT_ORDER);
        if (!this.REMOVE_ALIGNMENT_INFORMATION) {
            outHeader.setSequenceDictionary(inHeader.getSequenceDictionary());
            outHeader.setProgramRecords(inHeader.getProgramRecords());
        }
        SAMFileWriter out = new SAMFileWriterFactory().makeSAMOrBAMWriter(outHeader, presorted, this.OUTPUT);
        for (SAMRecord rec : in) {
            byte[] oq;
            if (this.RESTORE_ORIGINAL_QUALITIES && (oq = rec.getOriginalBaseQualities()) != null) {
                rec.setBaseQualities(oq);
                rec.setOriginalBaseQualities(null);
            }
            if (this.REMOVE_DUPLICATE_INFORMATION) {
                rec.setDuplicateReadFlag(false);
            }
            if (this.REMOVE_ALIGNMENT_INFORMATION) {
                boolean rc = !rec.getReadUnmappedFlag() && rec.getReadNegativeStrandFlag();
                rec.setReferenceIndex(-1);
                rec.setAlignmentStart(0);
                rec.setCigarString("*");
                rec.setMappingQuality(0);
                if (!rec.getReadUnmappedFlag()) {
                    rec.setDuplicateReadFlag(false);
                    rec.setInferredInsertSize(0);
                    rec.setNotPrimaryAlignmentFlag(false);
                    rec.setProperPairFlag(false);
                    rec.setReadNegativeStrandFlag(false);
                    rec.setReadUnmappedFlag(true);
                    if (rc) {
                        SAMRecordUtil.reverseComplement((SAMRecord)rec);
                    }
                }
                if (rec.getReadPairedFlag()) {
                    rec.setMateAlignmentStart(0);
                    rec.setMateNegativeStrandFlag(false);
                    rec.setMateReferenceIndex(-1);
                    rec.setMateUnmappedFlag(true);
                }
                for (String tag : this.ATTRIBUTE_TO_CLEAR) {
                    rec.setAttribute(tag, null);
                }
            }
            out.addAlignment(rec);
        }
        out.close();
        return 0;
    }
}

