/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.util.Collection;
import java.util.Comparator;
import java.util.PriorityQueue;
import net.sf.picard.PicardException;
import net.sf.picard.sam.ComparableSamRecordIterator;
import net.sf.picard.sam.ReservedTagConstants;
import net.sf.picard.sam.SamFileHeaderMerger;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordComparator;
import net.sf.samtools.SAMRecordCoordinateComparator;
import net.sf.samtools.util.CloseableIterator;

public class MergingSamRecordIterator
implements CloseableIterator<SAMRecord> {
    private final PriorityQueue<ComparableSamRecordIterator> pq;
    private final SamFileHeaderMerger samHeaderMerger;
    private final SAMFileHeader.SortOrder sortOrder;
    private final SAMRecordComparator comparator;
    private boolean initialized = false;
    private boolean iterationStarted = false;

    public MergingSamRecordIterator(SamFileHeaderMerger headerMerger, boolean forcePresorted) {
        this.samHeaderMerger = headerMerger;
        this.sortOrder = headerMerger.getMergedHeader().getSortOrder();
        this.comparator = this.getComparator();
        Collection<SAMFileReader> readers = headerMerger.getReaders();
        this.pq = new PriorityQueue(readers.size());
        for (SAMFileReader reader : readers) {
            if (forcePresorted || this.sortOrder == SAMFileHeader.SortOrder.unsorted || reader.getFileHeader().getSortOrder() == this.sortOrder) continue;
            throw new PicardException("Files are not compatible with sort order");
        }
    }

    public void addIterator(SAMFileReader reader, CloseableIterator<SAMRecord> iterator) {
        if (this.iterationStarted) {
            throw new PicardException("Cannot add another iterator; iteration has already begun");
        }
        if (!this.samHeaderMerger.getReaders().contains(reader)) {
            throw new PicardException("All iterators to be merged must be accounted for in the SAM header merger");
        }
        ComparableSamRecordIterator comparableIterator = new ComparableSamRecordIterator(reader, iterator, (Comparator<SAMRecord>)this.comparator);
        this.addIfNotEmpty(comparableIterator);
        this.initialized = true;
    }

    private void startIterationIfRequired() {
        if (this.initialized) {
            return;
        }
        for (SAMFileReader reader : this.samHeaderMerger.getReaders()) {
            this.addIterator(reader, (CloseableIterator<SAMRecord>)reader.iterator());
        }
        this.iterationStarted = true;
    }

    public void close() {
        for (ComparableSamRecordIterator iterator : this.pq) {
            iterator.close();
        }
    }

    public boolean hasNext() {
        this.startIterationIfRequired();
        return !this.pq.isEmpty();
    }

    public SAMRecord next() {
        String newGroupId;
        String oldGroupId;
        this.startIterationIfRequired();
        ComparableSamRecordIterator iterator = this.pq.poll();
        SAMRecord record = (SAMRecord)iterator.next();
        this.addIfNotEmpty(iterator);
        record.setHeader(this.samHeaderMerger.getMergedHeader());
        if (this.samHeaderMerger.hasReadGroupCollisions() && (oldGroupId = (String)record.getAttribute(ReservedTagConstants.READ_GROUP_ID)) != null) {
            newGroupId = this.samHeaderMerger.getReadGroupId(iterator.getReader(), oldGroupId);
            record.setAttribute(ReservedTagConstants.READ_GROUP_ID, (Object)newGroupId);
        }
        if (this.samHeaderMerger.hasProgramGroupCollisions() && (oldGroupId = (String)record.getAttribute(ReservedTagConstants.PROGRAM_GROUP_ID)) != null) {
            newGroupId = this.samHeaderMerger.getProgramGroupId(iterator.getReader(), oldGroupId);
            record.setAttribute(ReservedTagConstants.PROGRAM_GROUP_ID, (Object)newGroupId);
        }
        if (this.samHeaderMerger.hasMergedSequenceDictionary()) {
            if (record.getReferenceIndex() != -1) {
                record.setReferenceIndex(this.samHeaderMerger.getMergedSequenceIndex(iterator.getReader(), record.getReferenceIndex()).intValue());
            }
            if (record.getReadPairedFlag() && record.getMateReferenceIndex() != -1) {
                record.setMateReferenceIndex(this.samHeaderMerger.getMergedSequenceIndex(iterator.getReader(), record.getMateReferenceIndex()).intValue());
            }
        }
        return record;
    }

    private void addIfNotEmpty(ComparableSamRecordIterator iterator) {
        if (iterator.hasNext()) {
            this.pq.offer(iterator);
        } else {
            iterator.close();
        }
    }

    public void remove() {
        throw new UnsupportedOperationException("MergingSAMRecorderIterator.remove()");
    }

    private SAMRecordComparator getComparator() {
        if (this.sortOrder == SAMFileHeader.SortOrder.unsorted) {
            return new SAMRecordComparator(){

                public int fileOrderCompare(SAMRecord lhs, SAMRecord rhs) {
                    return System.identityHashCode(lhs) - System.identityHashCode(rhs);
                }

                public int compare(SAMRecord lhs, SAMRecord rhs) {
                    return this.fileOrderCompare(lhs, rhs);
                }
            };
        }
        if (this.samHeaderMerger.hasMergedSequenceDictionary() && this.sortOrder.equals((Object)SAMFileHeader.SortOrder.coordinate)) {
            return new MergedSequenceDictionaryCoordinateOrderComparator();
        }
        return this.sortOrder.getComparatorInstance();
    }

    public SAMFileHeader getMergedHeader() {
        return this.samHeaderMerger.getMergedHeader();
    }

    private class MergedSequenceDictionaryCoordinateOrderComparator
    extends SAMRecordCoordinateComparator {
        private MergedSequenceDictionaryCoordinateOrderComparator() {
        }

        public int fileOrderCompare(SAMRecord samRecord1, SAMRecord samRecord2) {
            int referenceIndex2;
            int referenceIndex1 = this.getReferenceIndex(samRecord1);
            if (referenceIndex1 != (referenceIndex2 = this.getReferenceIndex(samRecord2))) {
                if (referenceIndex1 == -1) {
                    return 1;
                }
                if (referenceIndex2 == -1) {
                    return -1;
                }
                return referenceIndex1 - referenceIndex2;
            }
            if (referenceIndex1 == -1) {
                return 0;
            }
            return samRecord1.getAlignmentStart() - samRecord2.getAlignmentStart();
        }

        private int getReferenceIndex(SAMRecord samRecord) {
            if (samRecord.getReferenceIndex() != -1) {
                return MergingSamRecordIterator.this.samHeaderMerger.getMergedSequenceIndex(samRecord.getHeader(), samRecord.getReferenceIndex());
            }
            if (samRecord.getMateReferenceIndex() != -1) {
                return MergingSamRecordIterator.this.samHeaderMerger.getMergedSequenceIndex(samRecord.getHeader(), samRecord.getMateReferenceIndex());
            }
            return -1;
        }
    }
}

