/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import net.sf.picard.PicardException;
import net.sf.picard.io.IoUtil;
import net.sf.picard.reference.ReferenceSequenceFileWalker;
import net.sf.picard.sam.ReservedTagConstants;
import net.sf.picard.sam.SamPairUtil;
import net.sf.picard.util.CigarUtil;
import net.sf.picard.util.Log;
import net.sf.picard.util.PeekableIterator;
import net.sf.samtools.BAMRecordCodec;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMProgramRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordCoordinateComparator;
import net.sf.samtools.SAMRecordIterator;
import net.sf.samtools.SAMRecordQueryNameComparator;
import net.sf.samtools.SAMRecordUtil;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMTag;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.SequenceUtil;
import net.sf.samtools.util.SortingCollection;

public abstract class AbstractAlignmentMerger {
    public static final int MAX_RECORDS_IN_RAM = 500000;
    private static final String RESERVED_ATTRIBUTE_STARTS = "XYZ";
    private final Log log = Log.getInstance(AbstractAlignmentMerger.class);
    private final File unmappedBamFile;
    private final File targetBamFile;
    private SAMSequenceDictionary sequenceDictionary = null;
    private ReferenceSequenceFileWalker refSeq = null;
    private final boolean clipAdapters;
    private final boolean bisulfiteSequence;
    private SAMProgramRecord programRecord;
    private final boolean jumpingLibrary;
    private final boolean alignedReadsOnly;
    private final SAMFileHeader header;

    protected abstract CloseableIterator<SAMRecord> getQuerynameSortedAlignedRecords();

    public AbstractAlignmentMerger(File unmappedBamFile, File targetBamFile, File referenceFasta, boolean clipAdapters, boolean bisulfiteSequence, boolean jumpingLibrary, boolean alignedReadsOnly, SAMProgramRecord programRecord) {
        this.unmappedBamFile = unmappedBamFile;
        this.targetBamFile = targetBamFile;
        IoUtil.assertFileIsReadable(unmappedBamFile);
        IoUtil.assertFileIsWritable(targetBamFile);
        if (referenceFasta != null) {
            String fastaPath;
            File sd;
            if (referenceFasta.exists()) {
                this.refSeq = new ReferenceSequenceFileWalker(referenceFasta);
            }
            this.sequenceDictionary = (sd = new File((fastaPath = referenceFasta.getAbsolutePath()).substring(0, fastaPath.lastIndexOf(".")) + ".dict")).exists() ? new SAMFileReader(IoUtil.openFileForReading(sd)).getFileHeader().getSequenceDictionary() : null;
        }
        this.clipAdapters = clipAdapters;
        this.bisulfiteSequence = bisulfiteSequence;
        this.jumpingLibrary = jumpingLibrary;
        this.alignedReadsOnly = alignedReadsOnly;
        this.programRecord = programRecord;
        this.header = new SAMFileHeader();
        this.header.setSortOrder(SAMFileHeader.SortOrder.coordinate);
        if (programRecord != null) {
            this.header.addProgramRecord(programRecord);
        }
        this.header.setSequenceDictionary(this.sequenceDictionary);
    }

    public void mergeAlignment() {
        SAMFileReader unmappedSam = null;
        if (this.unmappedBamFile != null) {
            unmappedSam = new SAMFileReader(IoUtil.openFileForReading(this.unmappedBamFile));
        }
        if (unmappedSam != null) {
            this.header.setReadGroups(unmappedSam.getFileHeader().getReadGroups());
        }
        int aligned = 0;
        int unmapped = 0;
        PeekableIterator<SAMRecord> alignedIterator = new PeekableIterator<SAMRecord>((Iterator<SAMRecord>)this.getQuerynameSortedAlignedRecords());
        SortingCollection alignmentSorted = SortingCollection.newInstance(SAMRecord.class, (SortingCollection.Codec)new BAMRecordCodec(this.header), (Comparator)new SAMRecordCoordinateComparator(), (int)500000);
        ClippedPairFixer pairFixer = new ClippedPairFixer((SortingCollection<SAMRecord>)alignmentSorted, this.header);
        SAMRecordIterator unmappedIterator = unmappedSam.iterator();
        SAMRecord nextAligned = alignedIterator.hasNext() ? alignedIterator.next() : null;
        Object lastAligned = null;
        UnmappedReadSorter unmappedSorter = new UnmappedReadSorter((CloseableIterator<SAMRecord>)unmappedIterator);
        while (unmappedSorter.hasNext()) {
            boolean eitherReadMapped;
            SAMRecord rec = unmappedSorter.next();
            rec.setReadName(this.cleanReadName(rec.getReadName()));
            if (nextAligned != null && rec.getReadName().compareTo(nextAligned.getReadName()) > 0) {
                throw new PicardException("Aligned Record iterator (" + nextAligned.getReadName() + ") is behind the umapped reads (" + rec.getReadName() + ")");
            }
            rec.setHeader(this.header);
            if (this.isMatch(rec, nextAligned)) {
                if (!this.ignoreAlignment(nextAligned)) {
                    this.setValuesFromAlignment(rec, nextAligned);
                    if (this.programRecord != null) {
                        rec.setAttribute(ReservedTagConstants.PROGRAM_GROUP_ID, (Object)this.programRecord.getProgramGroupId());
                    }
                    ++aligned;
                }
                nextAligned = alignedIterator.hasNext() ? alignedIterator.next() : null;
            } else {
                ++unmapped;
            }
            boolean bl = eitherReadMapped = !rec.getReadUnmappedFlag() || rec.getReadPairedFlag() && !rec.getMateUnmappedFlag();
            if (!eitherReadMapped && this.alignedReadsOnly) continue;
            pairFixer.add(rec);
        }
        unmappedIterator.close();
        alignedIterator.close();
        SAMFileWriter writer = new SAMFileWriterFactory().makeBAMWriter(this.header, true, this.targetBamFile);
        int count = 0;
        for (SAMRecord rec : alignmentSorted) {
            if (!rec.getReadUnmappedFlag() && this.refSeq != null) {
                byte[] referenceBases = this.refSeq.get(rec.getReferenceIndex()).getBases();
                rec.setAttribute(SAMTag.NM.name(), (Object)SequenceUtil.calculateSamNmTag((SAMRecord)rec, (byte[])referenceBases, (int)0, (boolean)this.bisulfiteSequence));
                rec.setAttribute(SAMTag.UQ.name(), (Object)SequenceUtil.sumQualitiesOfMismatches((SAMRecord)rec, (byte[])referenceBases, (int)0, (boolean)this.bisulfiteSequence));
            }
            writer.addAlignment(rec);
            if (++count % 1000000 != 0) continue;
            this.log.info(count + " SAMRecords written to " + this.targetBamFile.getName());
        }
        writer.close();
        this.log.info("Wrote " + aligned + " alignment records and " + unmapped + " unmapped reads.");
    }

    protected boolean isMatch(SAMRecord unaligned, SAMRecord aligned) {
        return aligned != null && aligned.getReadName().equals(unaligned.getReadName()) && (!unaligned.getReadPairedFlag() || aligned.getFirstOfPairFlag() == unaligned.getFirstOfPairFlag());
    }

    protected void setValuesFromAlignment(SAMRecord rec, SAMRecord alignment) {
        for (SAMRecord.SAMTagAndValue attr : alignment.getAttributes()) {
            if (RESERVED_ATTRIBUTE_STARTS.indexOf(attr.tag.charAt(0)) != -1) continue;
            rec.setAttribute(attr.tag, attr.value);
        }
        rec.setReadUnmappedFlag(alignment.getReadUnmappedFlag());
        rec.setReferenceIndex(alignment.getReferenceIndex().intValue());
        rec.setAlignmentStart(alignment.getAlignmentStart());
        rec.setReadNegativeStrandFlag(alignment.getReadNegativeStrandFlag());
        if (!alignment.getReadUnmappedFlag()) {
            rec.setCigar(alignment.getCigar());
            rec.setMappingQuality(alignment.getMappingQuality());
        }
        if (rec.getReadPairedFlag()) {
            rec.setProperPairFlag(alignment.getProperPairFlag());
            rec.setInferredInsertSize(alignment.getInferredInsertSize());
            rec.setMateUnmappedFlag(alignment.getMateUnmappedFlag());
            rec.setMateReferenceIndex(alignment.getMateReferenceIndex().intValue());
            rec.setMateAlignmentStart(alignment.getMateAlignmentStart());
            rec.setMateNegativeStrandFlag(alignment.getMateNegativeStrandFlag());
        }
        if (rec.getReadNegativeStrandFlag()) {
            SAMRecordUtil.reverseComplement((SAMRecord)rec);
        }
        if (this.clipAdapters && rec.getAttribute("XT") != null) {
            CigarUtil.softClip3PrimeEndOfRead(rec, rec.getIntegerAttribute("XT"));
        }
    }

    protected String cleanReadName(String readName) {
        if (readName.endsWith("/1") || readName.endsWith("/2")) {
            readName = readName.substring(0, readName.length() - 2);
        }
        return readName;
    }

    protected SAMSequenceDictionary getSequenceDictionary() {
        return this.sequenceDictionary;
    }

    protected SAMProgramRecord getProgramRecord() {
        return this.programRecord;
    }

    protected void setProgramRecord(SAMProgramRecord pg) {
        this.programRecord = pg;
        this.header.addProgramRecord(pg);
    }

    protected boolean isJumpingLibrary() {
        return this.jumpingLibrary;
    }

    protected SAMFileHeader getHeader() {
        return this.header;
    }

    protected boolean ignoreAlignment(SAMRecord sam) {
        return false;
    }

    private static class ClippedPairFixer {
        private final SortingCollection<SAMRecord> collection;
        private final SAMFileHeader header;
        private SAMRecord pending = null;

        public ClippedPairFixer(SortingCollection<SAMRecord> collection, SAMFileHeader header) {
            this.collection = collection;
            this.header = header;
        }

        public void add(SAMRecord record) {
            if (!record.getReadPairedFlag()) {
                this.collection.add((Object)record);
            } else if (this.pending == null) {
                this.pending = record;
            } else {
                if (!record.getReadName().equals(this.pending.getReadName())) {
                    throw new PicardException("Non-paired reads: " + record.getReadName() + ", " + this.pending.getReadName());
                }
                if (!record.getReadUnmappedFlag() && !this.pending.getReadUnmappedFlag() && record.getReadNegativeStrandFlag() != this.pending.getReadNegativeStrandFlag()) {
                    SAMRecord neg;
                    SAMRecord pos = record.getReadNegativeStrandFlag() ? this.pending : record;
                    SAMRecord sAMRecord = neg = record.getReadNegativeStrandFlag() ? record : this.pending;
                    if (pos.getAlignmentStart() < neg.getAlignmentEnd()) {
                        int posDiff = pos.getAlignmentEnd() - neg.getAlignmentEnd();
                        int negDiff = pos.getAlignmentStart() - neg.getAlignmentStart();
                        if (posDiff > 0) {
                            CigarUtil.softClip3PrimeEndOfRead(pos, Math.min(pos.getReadLength(), pos.getReadLength() - posDiff + 1));
                        }
                        if (negDiff > 0) {
                            CigarUtil.softClip3PrimeEndOfRead(neg, Math.min(neg.getReadLength(), neg.getReadLength() - negDiff + 1));
                        }
                    }
                }
                SamPairUtil.setMateInfo(record, this.pending, this.header);
                this.collection.add((Object)this.pending);
                this.collection.add((Object)record);
                this.pending = null;
            }
        }
    }

    protected static class UnmappedReadSorter {
        private final TreeSet<SAMRecord> reallySorted = new TreeSet(new SAMRecordQueryNameComparator());
        private final CloseableIterator<SAMRecord> unmappedReads;

        public UnmappedReadSorter(CloseableIterator<SAMRecord> unmappedReads) {
            this.unmappedReads = unmappedReads;
            for (int i = 0; i < 3; ++i) {
                if (!unmappedReads.hasNext()) continue;
                this.reallySorted.add((SAMRecord)unmappedReads.next());
            }
        }

        public boolean hasNext() {
            return this.reallySorted.size() > 0;
        }

        public SAMRecord next() {
            if (this.reallySorted.size() == 0) {
                throw new ArrayIndexOutOfBoundsException("No such element in UnmappedReadSorter!");
            }
            SAMRecord next = this.reallySorted.first();
            this.reallySorted.remove(next);
            if (this.unmappedReads.hasNext()) {
                this.reallySorted.add((SAMRecord)this.unmappedReads.next());
            }
            return next;
        }
    }
}

