/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.reference;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.picard.reference.ReferenceSequenceFile;
import net.sf.picard.reference.ReferenceSequenceFileFactory;
import net.sf.samtools.util.CloserUtil;

public class NormalizeFasta
extends CommandLineProgram {
    @Usage
    public final String USAGE = "Takes any file that conforms to the fasta format and normalizes it so that all lines of sequence except the last line per named sequence are of the same length.";
    @Option(shortName="I", doc="The input fasta file to normalize.")
    public File INPUT;
    @Option(shortName="O", doc="The output fasta file to write.")
    public File OUTPUT;
    @Option(doc="The line length to be used for the output fasta file.")
    public int LINE_LENGTH = 100;
    @Option(doc="Truncate sequence names at first whitespace.")
    public boolean TRUNCATE_SEQUENCE_NAMES_AT_WHITESPACE = false;

    public static void main(String[] args) {
        new NormalizeFasta().instanceMainWithExit(args);
    }

    @Override
    protected int doWork() {
        IoUtil.assertFileIsReadable(this.INPUT);
        IoUtil.assertFileIsWritable(this.OUTPUT);
        if (this.INPUT.getAbsoluteFile().equals(this.OUTPUT.getAbsoluteFile())) {
            throw new IllegalArgumentException("Input and output cannot be the same file.");
        }
        ReferenceSequenceFile ref = ReferenceSequenceFileFactory.getReferenceSequenceFile(this.INPUT, this.TRUNCATE_SEQUENCE_NAMES_AT_WHITESPACE);
        BufferedWriter out = IoUtil.openFileForBufferedWriting(this.OUTPUT);
        ReferenceSequence seq = null;
        while ((seq = ref.nextSequence()) != null) {
            String name = seq.getName();
            byte[] bases = seq.getBases();
            try {
                out.write(">");
                out.write(name);
                out.newLine();
                for (int i = 0; i < bases.length; ++i) {
                    if (i > 0 && i % this.LINE_LENGTH == 0) {
                        out.write("\n");
                    }
                    out.write(bases[i]);
                }
                out.write("\n");
            }
            catch (IOException ioe) {
                throw new PicardException("Error writing to file " + this.OUTPUT.getAbsolutePath(), ioe);
            }
        }
        CloserUtil.close((Object)out);
        return 0;
    }
}

