/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.reference;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.MatchResult;
import net.sf.picard.PicardException;
import net.sf.picard.io.IoUtil;
import net.sf.picard.reference.FastaSequenceIndexEntry;
import net.sf.samtools.SAMSequenceRecord;

public class FastaSequenceIndex
implements Iterable<FastaSequenceIndexEntry> {
    private final Map<String, FastaSequenceIndexEntry> sequenceEntries = new LinkedHashMap<String, FastaSequenceIndexEntry>();

    public FastaSequenceIndex(File indexFile) {
        IoUtil.assertFileIsReadable(indexFile);
        this.parseIndexFile(indexFile);
    }

    protected FastaSequenceIndex() {
    }

    protected void add(FastaSequenceIndexEntry indexEntry) {
        FastaSequenceIndexEntry ret = this.sequenceEntries.put(indexEntry.getContig(), indexEntry);
        if (ret != null) {
            throw new PicardException("Contig '" + indexEntry.getContig() + "' already exists in fasta index.");
        }
    }

    protected void rename(FastaSequenceIndexEntry entry, String newName) {
        this.sequenceEntries.remove(entry.getContig());
        entry.setContig(newName);
        this.add(entry);
    }

    private void parseIndexFile(File indexFile) {
        try {
            Scanner scanner = new Scanner(indexFile);
            while (scanner.hasNext()) {
                String result = scanner.findInLine("(.+)\\t+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)");
                if (result == null) {
                    throw new PicardException("Found invalid line in index file:" + scanner.nextLine());
                }
                MatchResult tokens = scanner.match();
                if (tokens.groupCount() != 5) {
                    throw new PicardException("Found invalid line in index file:" + scanner.nextLine());
                }
                scanner.nextLine();
                String contig = tokens.group(1);
                long size = Long.valueOf(tokens.group(2));
                long location = Long.valueOf(tokens.group(3));
                int basesPerLine = Integer.valueOf(tokens.group(4));
                int bytesPerLine = Integer.valueOf(tokens.group(5));
                contig = SAMSequenceRecord.truncateSequenceName((String)contig);
                this.add(new FastaSequenceIndexEntry(contig, location, size, basesPerLine, bytesPerLine));
            }
        }
        catch (FileNotFoundException e) {
            throw new PicardException("Fasta index file should be found but is not: " + indexFile, e);
        }
    }

    public boolean hasIndexEntry(String contigName) {
        return this.sequenceEntries.containsKey(contigName);
    }

    public FastaSequenceIndexEntry getIndexEntry(String contigName) {
        if (!this.hasIndexEntry(contigName)) {
            throw new PicardException("Unable to find entry for contig: " + contigName);
        }
        return this.sequenceEntries.get(contigName);
    }

    @Override
    public Iterator<FastaSequenceIndexEntry> iterator() {
        return this.sequenceEntries.values().iterator();
    }

    public int size() {
        return this.sequenceEntries.size();
    }
}

