/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.analysis;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.sf.picard.PicardException;
import net.sf.picard.analysis.InsertSizeMetrics;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.metrics.MetricsFile;
import net.sf.picard.sam.SamPairUtil;
import net.sf.picard.util.Histogram;
import net.sf.picard.util.Log;
import net.sf.picard.util.RExecutor;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.CloseableIterator;

public class CollectInsertSizeMetrics
extends CommandLineProgram {
    private static final Log log = Log.getInstance(CollectInsertSizeMetrics.class);
    private static final String HISTOGRAM_R_SCRIPT = "net/sf/picard/analysis/insertSizeHistogram.R";
    @Usage
    public String USAGE = "Reads a SAM or BAM file and writes a file containing metrics about the statistical distribution of insert size (excluding duplicates) and generates a histogram plot.\n";
    @Option(shortName="I", doc="SAM or BAM file")
    public File INPUT;
    @Option(shortName="O", doc="File to write insert size metrics to")
    public File OUTPUT;
    @Option(shortName="H", doc="File to write insert size histogram chart to")
    public File HISTOGRAM_FILE;
    @Option(shortName="T", doc="When calculating mean and stdev stop when the bins in the tail of the distribution contain fewer than mode/TAIL_LIMIT items. This also limits how much data goes into each data category of the histogram.")
    public int TAIL_LIMIT = 10000;
    @Option(shortName="W", doc="Explicitly sets the histogram width, overriding the TAIL_LIMIT option. Also, when calculating mean and stdev, only bins <= HISTOGRAM_WIDTH will be included.", optional=true)
    public Integer HISTOGRAM_WIDTH = null;
    @Option(shortName="M", doc="When generating the histogram, discard any data categories (out of FR, TANDEM, RF) that have fewer than this percentage of overall reads. (Range: 0 to 1)")
    public float MINIMUM_PCT = 0.01f;
    @Option(doc="Stop after processing N reads, mainly for debugging.")
    public int STOP_AFTER = 0;

    public static void main(String[] argv) {
        System.exit(new CollectInsertSizeMetrics().instanceMain(argv));
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.MINIMUM_PCT < 0.0f || (double)this.MINIMUM_PCT > 0.5) {
            return new String[]{"MINIMUM_PCT was set to " + this.MINIMUM_PCT + ". It must be between 0 and 0.5 so all data categories don't get discarded."};
        }
        return super.customCommandLineValidation();
    }

    @Override
    protected int doWork() {
        IoUtil.assertFileIsReadable(this.INPUT);
        IoUtil.assertFileIsWritable(this.OUTPUT);
        IoUtil.assertFileIsWritable(this.HISTOGRAM_FILE);
        SAMFileReader in = new SAMFileReader(this.INPUT);
        in.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
        MetricsFile<InsertSizeMetrics, Integer> file = this.collectMetrics((CloseableIterator<SAMRecord>)in.iterator());
        in.close();
        file.write(this.OUTPUT);
        if (file.getMetrics().get((int)0).READ_PAIRS == 0L) {
            log.warn("Input file did not contain any records with insert size information.");
        } else {
            int rResult = this.HISTOGRAM_WIDTH == null ? RExecutor.executeFromClasspath(HISTOGRAM_R_SCRIPT, this.OUTPUT.getAbsolutePath(), this.HISTOGRAM_FILE.getAbsolutePath(), this.INPUT.getName()) : RExecutor.executeFromClasspath(HISTOGRAM_R_SCRIPT, this.OUTPUT.getAbsolutePath(), this.HISTOGRAM_FILE.getAbsolutePath(), this.INPUT.getName(), String.valueOf(this.HISTOGRAM_WIDTH));
            if (rResult != 0) {
                throw new PicardException("R script net/sf/picard/analysis/insertSizeHistogram.R failed with return code " + rResult);
            }
        }
        return 0;
    }

    MetricsFile<InsertSizeMetrics, Integer> collectMetrics(CloseableIterator<SAMRecord> samIterator) {
        HashMap histograms = new HashMap();
        histograms.put(SamPairUtil.PairOrientation.FR, new Histogram("insert_size", "fr_count"));
        histograms.put(SamPairUtil.PairOrientation.TANDEM, new Histogram("insert_size", "tandem_count"));
        histograms.put(SamPairUtil.PairOrientation.RF, new Histogram("insert_size", "rf_count"));
        int validRecordCounter = 0;
        while (samIterator.hasNext()) {
            SAMRecord record = (SAMRecord)samIterator.next();
            if (this.skipRecord(record)) continue;
            int insertSize = Math.abs(record.getInferredInsertSize());
            SamPairUtil.PairOrientation orientation = SamPairUtil.getPairOrientation(record);
            ((Histogram)histograms.get((Object)orientation)).increment(insertSize);
            if (this.STOP_AFTER <= 0 || ++validRecordCounter < this.STOP_AFTER) continue;
            break;
        }
        MetricsFile<InsertSizeMetrics, Integer> file = this.getMetricsFile();
        for (Map.Entry entry : histograms.entrySet()) {
            SamPairUtil.PairOrientation pairOrientation = (SamPairUtil.PairOrientation)((Object)entry.getKey());
            Histogram histogram = (Histogram)entry.getValue();
            double total = histogram.getCount();
            InsertSizeMetrics metrics = new InsertSizeMetrics();
            if (!(total > (double)((float)validRecordCounter * this.MINIMUM_PCT))) continue;
            metrics.PAIR_ORIENTATION = pairOrientation;
            metrics.READ_PAIRS = (long)total;
            metrics.MAX_INSERT_SIZE = (int)histogram.getMax();
            metrics.MIN_INSERT_SIZE = (int)histogram.getMin();
            metrics.MEDIAN_INSERT_SIZE = histogram.getMedian();
            double median = histogram.getMedian();
            double covered = 0.0;
            double low = median;
            for (double high = median; low >= histogram.getMin() || high <= histogram.getMax(); low -= 1.0, high += 1.0) {
                Histogram.Bin highBin;
                Histogram.Bin lowBin = (Histogram.Bin)histogram.get((int)low);
                if (lowBin != null) {
                    covered += lowBin.getValue();
                }
                if (low != high && (highBin = (Histogram.Bin)histogram.get((int)high)) != null) {
                    covered += highBin.getValue();
                }
                double percentCovered = covered / total;
                int distance = (int)(high - low) + 1;
                if (percentCovered >= 0.1 && metrics.WIDTH_OF_10_PERCENT == 0) {
                    metrics.WIDTH_OF_10_PERCENT = distance;
                }
                if (percentCovered >= 0.2 && metrics.WIDTH_OF_20_PERCENT == 0) {
                    metrics.WIDTH_OF_20_PERCENT = distance;
                }
                if (percentCovered >= 0.3 && metrics.WIDTH_OF_30_PERCENT == 0) {
                    metrics.WIDTH_OF_30_PERCENT = distance;
                }
                if (percentCovered >= 0.4 && metrics.WIDTH_OF_40_PERCENT == 0) {
                    metrics.WIDTH_OF_40_PERCENT = distance;
                }
                if (percentCovered >= 0.5 && metrics.WIDTH_OF_50_PERCENT == 0) {
                    metrics.WIDTH_OF_50_PERCENT = distance;
                }
                if (percentCovered >= 0.6 && metrics.WIDTH_OF_60_PERCENT == 0) {
                    metrics.WIDTH_OF_60_PERCENT = distance;
                }
                if (percentCovered >= 0.7 && metrics.WIDTH_OF_70_PERCENT == 0) {
                    metrics.WIDTH_OF_70_PERCENT = distance;
                }
                if (percentCovered >= 0.8 && metrics.WIDTH_OF_80_PERCENT == 0) {
                    metrics.WIDTH_OF_80_PERCENT = distance;
                }
                if (percentCovered >= 0.9 && metrics.WIDTH_OF_90_PERCENT == 0) {
                    metrics.WIDTH_OF_90_PERCENT = distance;
                }
                if (!(percentCovered >= 0.99) || metrics.WIDTH_OF_99_PERCENT != 0) continue;
                metrics.WIDTH_OF_99_PERCENT = distance;
            }
            Histogram trimmedHisto = histogram;
            if (this.HISTOGRAM_WIDTH != null) {
                trimmedHisto.trimByWidth(this.HISTOGRAM_WIDTH);
            } else {
                trimmedHisto.trimByTailLimit(this.TAIL_LIMIT);
            }
            metrics.MEAN_INSERT_SIZE = trimmedHisto.getMean();
            metrics.STANDARD_DEVIATION = trimmedHisto.getStandardDeviation();
            file.addHistogram(trimmedHisto);
            file.addMetric(metrics);
        }
        if (file.getNumHistograms() == 0) {
            throw new PicardException("All data categories were discarded becaused they had an insufficient percentage of the data. Try lowering MINIMUM_PCT (currently set to: " + this.MINIMUM_PCT + ").");
        }
        return file;
    }

    private boolean skipRecord(SAMRecord record) {
        return !record.getReadPairedFlag() || record.getMateUnmappedFlag() || record.getFirstOfPairFlag() || record.getNotPrimaryAlignmentFlag() || record.getDuplicateReadFlag() || record.getInferredInsertSize() == 0;
    }
}

