#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#define E 1 //3=full info on stderr 2=info & progress 1=only progress 0=none
#define S 1 //1=skip  unlike  inversions 0=do not skip (may never end)
#define R 1 //1=readable summary, 0=summary for make_table.pl

void ddqs(int*,int,int);
void dqsort(int*,double*,int,int);
int  migord[24][4]={{1,2,3,4}, {1,2,4,3}, {1,3,2,4}, {1,3,4,2}, {1,4,2,3}, {1,4,3,2}, 
                    {2,1,3,4}, {2,1,4,3}, {2,3,1,4}, {2,3,4,1}, {2,4,1,3}, {2,4,3,1}, 
                    {3,1,2,4}, {3,1,4,2}, {3,2,1,4}, {3,2,4,1}, {3,4,1,2}, {3,4,2,1}, 
                    {4,1,2,3}, {4,1,3,2}, {4,2,1,3}, {4,2,3,1}, {4,3,1,2}, {4,3,2,1}};

int main(int argc, char* argv[]) {
	FILE *in,*pf;
	double p,b0,b1,b2,b3,ccd;
	int i0,i1,i2,i3,u1,u2;
	int d0,d1,d2,d3,g0,g1,g2,g3;
	int b,c,d,f,h,i,j,k,m,n,r,s,w,v,x,cr,rr,ur,tur=0;
	int nn,nb,nf,ng,ne,ni,oc,mc,oh,mh,mp,np,ht,cncr,cnhs;

	if(argc<9) { fprintf(stderr,"Usage %s input_file.txt number-of-simulations resilince: (degree speed mode) fragility: (degree speed mode-file)\n",argv[0]); return -1; }
	if((in=fopen(argv[1],"rt"))==NULL) { fprintf(stderr,"Cannot open input file\n"); return -1; }
	if((pf=fopen(argv[8],"rt"))==NULL) { fprintf(stderr,"Cannot open p-vls file\n"); return -1; }

	int     ns=atoi(argv[2]);
	double  cc=atof(argv[3]); double cd=atof(argv[4]); assert(0<=cc && cc<=1); 
	double  hc=atof(argv[6]); int    hd=atoi(argv[7]); assert(0<=hc && hc<=1); if(hc==0) hd=0;
	int     fm=atoi(argv[5]); //1=classic 2=random 3=reverse 4=positively-correlated 5=negatively-correlated
	assert(1<=fm && fm<=5);
	
	assert(fscanf(in,"%i" ,&nn)); assert(fscanf(in,"%i",&nf)); assert(fscanf(in,"%i",&ng));
	assert(fscanf(in,"%i" ,&mc)); assert(fscanf(in,"%i",&mh)); assert(fscanf(in,"%i",&mp));

	double allb1[nn][ng]; 
	double allb2[nn][ng]; 
	int    allix[nn][ng];
	int tree[nb=nn-1][4];       for(i=0;i<nb;i++) for(j=0;j< 3;j++) assert(fscanf(in, "%i",&tree[i][j]));
	assert(fscanf(in,"%i",&ne)); int    cend[ne]; for(i=0;i<ne;i++) assert(fscanf(in, "%i",&cend[i])); assert(ne%2==0);
	assert(fscanf(in,"%i",&ni)); int    sinv[ni]; for(i=0;i<ni;i++) assert(fscanf(in, "%i",&sinv[i]));
	assert(fscanf(in,"%i",&oc)); int    obcd[oc]; for(i=0;i<oc;i++) assert(fscanf(in, "%i",&obcd[i]));
	assert(fscanf(in,"%i",&oh)); int    obht[oh]; for(i=0;i<oh;i++) assert(fscanf(in, "%i",&obht[i])); assert(oh%2==0);
	assert(fscanf(pf,"%i",&np)); double pv[np+1]; for(i=0;i<np;i++) assert(fscanf(pf,"%lf",&pv[i+1]));
	assert(fscanf(pf,"%i",&ht)); assert(ht==0 || ht==1);
	for(j=i=0;i<nb;i++) j+=(tree[i][3]=tree[i][2]); assert(j==ni);

	double msru=0.0,nruc=0.0,msrn=0.0,nrnu=0.0;
	double nplr=0.0,nsol=0.0,oluc=0.0;
	int    cflr= 21,cfmr= 10,cfsr=  2;
	double nslr=0.0,nsmr=0.0,nssr=0.0;
	double cclr=0.0,ccmr=0.0,ccsr=0.0;
	double tclr=0.0,tcmr=0.0,tcsr=0.0;
	double sclr=0.0,scmr=0.0,scsr=0.0;
	double nblr=0.0,nbmr=0.0,nbsr=0.0;
	double rw2h=0.0,rw1h=0.0,cfhr=1-hc*(1-pv[3]);

	int    tmph[oh],rndh[oh],strc[oc],cind[oc],rr2g[ni][4];
	int    tmpc[oc],rndc[oc],brk1[ng],pct1[ng],ceix[ne],prs1[ng][nf]; 
	int    tmpi[ni],rndi[ni],brk2[ng],pct2[ng],indx[ng],prs2[ng][nf]; 
	double clds[mc+1],hots[mh+1],ngps[mp+1],ptb1[ng],ponb[oc];
	double cldt[mc+1],hott[mh+1],ngpt[mp+1],ptb2[ng],abri[mc+1];

	for(i=0;i<=mc;i++) cldt[i]=0;
	for(i=0;i<=mh;i++) hott[i]=0;
	for(i=0;i<=mp;i++) ngpt[i]=0;
	for(i=0;i<=mc;i++) abri[i]=0;

	for(i=0;i<oh;i++) assert(1<=obht[i]);
	for(i=0;i<oh;i++) if(np<obht[i]) obht[i]=np;
	ddqs(obht,0,oh-1);
	for(i=1,j=oh-2;i<j;i+=2,j-=2) { h=obht[i]; obht[i]=obht[j]; obht[j]=h; }

	for(cr=i=0;i<oc;i++) if( obcd[i]) cr+=obcd[i]-1; cr=(int)(cr*cc+0.5); cd*=cr;
	for( i=j=0;j<oc;j++) if(!obcd[j]) ceix[i++]=j;   assert(i==ne);

	if(E>1) {
		fprintf(stderr,"(ns,cc|fm,hc)=(%i,%.2lf|%i,%.3lf) ",ns,cc,fm,hc);
		fprintf(stderr,"(nn,nf,ng)=(%i,%i,%i) "               ,nn,nf,ng);
		fprintf(stderr,"(mc,mh,mp)=(%i,%i,%i) "               ,mc,mh,mp);
		fprintf(stderr,"(ne,ni,oc,oh)=(%i,%i,%i,%i)\n"     ,ne,ni,oc,oh);
	}
	srand48(0);
	for(ccd=0,rr=0,i=0;i<ns;rr=0,ccd=0) {
		for(j=0;j<ng;j++ ){ 
			brk1[j]=0; ptb1[j]=1; pct1[j]=0; 
			brk2[j]=0; ptb2[j]=1; pct2[j]=0;
		}
		for(j=0;j<ne;j+=2){ ptb1[cend[j]]=0; ptb2[cend[j+1]]=0; }
		//set cold-regions
		if(cr>0) {
			for(j=0;j<oc;j++) cind[j]=j;
			for(j=0;j<oc;j++) tmpc[j]=obcd[j];
			for(j=0;j<ne;j+=2){
				rndc[ceix[j  ]]=tmpc[ceix[j  ]];
				rndc[ceix[j+1]]=tmpc[ceix[j+1]];
				for(m=ceix[j+1]-ceix[j]-1,k=ceix[j]+1;k<ceix[j+1];k++,m--) {
					rndc[k]=tmpc[n=(int)(drand48()*m)+ceix[j]+1];
					for(n++;n<m+ceix[j]+1;n++) tmpc[n-1]=tmpc[n];
				}
			}
			for(m=j=0;j<oc;m+=rndc[j]?rndc[j]:1,j++) strc[j]=m;
			if     (fm==1) for(j=0;j<oc;j++) ponb[j]=rndc[j];         //classic
			else if(fm==2) for(j=0;j<oc;j++) ponb[j]=drand48();       //random
			else if(fm==3) for(j=0;j<oc;j++) ponb[j]=1.0/(rndc[j]+1); //reverse
			else if(fm==4) for(j=0;j<oc;j++) ponb[j]=rndc[j]>7?0.5+0.5*drand48():    0.5*drand48();
			else if(fm==5) for(j=0;j<oc;j++) ponb[j]=rndc[j]>7?    0.5*drand48():0.5+0.5*drand48();
			dqsort(cind,ponb,0,oc-1);
			for(cncr=n=j=0;j<oc;j++) {
				if(rndc[k=cind[j]]<=1) continue;
				if(n+rndc[k]-1>cr) {
					if(rndc[k]==2) break;
					msrn+=rndc[k];
					nrnu++;
					continue;
				}
				for(m=strc[k];m<strc[k]+rndc[k]-1;m++) { ptb2[m]=0; ptb1[m+1]=0; }
				if(rndc[k]>=cflr) nplr++;
				n+=rndc[k]-1;
				msru+=rndc[k];
				nruc++;
				cncr++;
			}
			for(;j<oc;j++) {
				if(rndc[k=cind[j]]<=1) continue;
				msrn+=rndc[k];
				nrnu++;
			}
			cnhs=ng-cncr;
		}
		if(hc>0) {
			if(ht) {
				for(j=0;j<oh;j++) tmph[j]=obht[j];
				for(m=oh,k=0;k<oh;k++,m--) {
					rndh[k]=tmph[n=(int)(drand48()*m)];
					for(n++;n<m;n++) tmph[n-1]=tmph[n];
				}
			}
			else {
				for(j=0;j<oh;j+=2) { 
					if(drand48()<0.5) { rndh[j]=obht[j+1] ;  rndh[j+1]= obht[j  ]; } 
					else              { rndh[j]=obht[j  ] ;  rndh[j+1]= obht[j+1]; } 
				}
			}
			for(j=0;j<oh;) if(ptb2[k=(int)(drand48()*ng)]==1 && ptb1[k+1]==1) { ptb2[k]=rndh[j++]; ptb1[k+1]=rndh[j++]; }
			for(j=0;j<ng;j++) if(ptb1[j]) ptb1[j]=1-hc*(1-pv[(int)ptb1[j]]);
			for(j=0;j<ng;j++) if(ptb2[j]) ptb2[j]=1-hc*(1-pv[(int)ptb2[j]]);
			
		}
		//make rearrangements
		for(k=tree[0][0],j=0;j<ng;j++ ){ 
			allix[k][j]=j;
			allb1[k][j]=ptb1[j];
			allb2[k][j]=ptb2[j];
		}
		for(j=ni,b=0;b<nb;b++) {
			for(m=tree[b][0],k=0;k<ng;k++) {
				indx[k]=allix[m][k];
				ptb1[k]=allb1[m][k];
				ptb2[k]=allb2[m][k];
			}
			for(v=0;v<tree[b][2];j++) {
				if(j==ni) {
					for(k=0;k<ni;k++) tmpi[k]=sinv[k];
					for(m=ni,k=0;k<ni;k++,m--) {
						rndi[k]=tmpi[n=(int)(drand48()*m)];
						for(n++;n<m;n++) tmpi[n-1]=tmpi[n];
					}
					j=0;
				}
				for(w=0;w<1e5*(ng-rndi[j]);w++,w*=S) {
					i1=(int)((ng-rndi[j]-1)*drand48())+1;
					i2=i1+rndi[j]-1;
					if(ne>2) {
						for(k=1;k<ne-1;k++) if(i1<=cend[k] && cend[k]<=i2) break;
						if(k<ne-1) continue;
					}
					if((g1=indx[i1  ])<0) { g1*=-1; b1=ptb2[g1]; d1=-1; } else { b1=ptb1[g1]; d1=1; } if(!b1) continue;
					if((g2=indx[i2  ])<0) { g2*=-1; b2=ptb1[g2]; d2=-1; } else { b2=ptb2[g2]; d2=1; } if(!b2) continue;
					if((g0=indx[i1-1])<0) { g0*=-1; b0=ptb1[g0]; d0=-1; } else { b0=ptb2[g0]; d0=1; }
					if((g3=indx[i2+1])<0) { g3*=-1; b3=ptb2[g3]; d3=-1; } else { b3=ptb1[g3]; d3=1; }
					//if(b0*b1*b2*b3<drand48()) continue;            //a little bit faster new version
					if((p=b0*b1*b2*b3)<1 && p<drand48()) continue;   //an original version used for static
					if(d0<0) { brk1[g0]++; rr2g[rr  ][0]=-g0; } else { brk2[g0]++; rr2g[rr  ][0]= g0; }
					if(d1<0) { brk2[g1]++; rr2g[rr  ][1]= g1; } else { brk1[g1]++; rr2g[rr  ][1]=-g1; }
					if(d2<0) { brk1[g2]++; rr2g[rr  ][2]=-g2; } else { brk2[g2]++; rr2g[rr  ][2]= g2; }
					if(d3<0) { brk2[g3]++; rr2g[rr++][3]= g3; } else { brk1[g3]++; rr2g[rr++][3]=-g3; } 
					for(r=i2-i1,n=i2,m=i1,k=0;k<=r/2;k++,m++,n--) {
						x=indx[m];
						indx[m]=indx[n];
						indx[n]=x;
					}
					for(k=i1;k<=i2;k++) indx[k]*=-1;
					k=0;
					if(b0>=cfhr) k++;
					if(b1>=cfhr) k++;
					if(b2>=cfhr) k++;
					if(b3>=cfhr) k++;
					if(k>=1)  rw1h++;
					if(k>=2)  rw2h++;
					//migrate cold-regions
					for(s=0,r=0;ccd<cd*rr && r<3*cncr;r++) {
						for(b1=1;b1;) { if((g1=indx[i1=(int)((ng-1)*drand48())+1])<0) { b1=ptb2[g1*=-1]; d1=-1; } else { b1=ptb1[g1]; d1=1; } }
						if(ne>2) {
							for(n=0;n<ne;n+=2) if(cend[n]<i1 && i1<=cend[n+1]) break;
							if(n==ne) continue;
						}
						else n=0;
						for(i0=i1-1;i0>cend[n  ];i0--) { if((g0=indx[i0])<0) { if(ptb2[g0*=-1]) { d0=-1 ; break; } } else if(ptb1[g0]) { d0=1; break; } }
						for(       ;i1<cend[n+1];i1++) { if((g1=indx[i1])<0) { if(ptb1[g1*=-1]) { d1=-1 ; break; } } else if(ptb2[g1]) { d1=1; break; } }
						if(i1-i0==1) { //move a cluster of size of 2 to new place avoding cluster-fusions
							for(;s<3*cnhs;s++) {
								for(b2=0;!b2;) { if((g2=indx[i2=cend[n]+(int)((cend[n+1]-cend[n])*drand48())])<0) { b2=ptb1[g2*=-1]; d2=-1; } else { b2=ptb2[g2]; d2=1; } }
								                 if((g3=indx[i3=i2+1]                                        )<0) { b3=ptb2[g3*=-1]; d3=-1; } else { b3=ptb1[g3]; d3=1; }
								if(cend[n  ]< i2) { if(d2<0) { if(!ptb2[g2]) continue; } else if(!ptb1[g2]) continue; }
								if(cend[n+1]> i3) { if(d3<0) { if(!ptb1[g3]) continue; } else if(!ptb2[g3]) continue; }
								if(drand48()<0.5) { if(d0<0) ptb1[g0]=b2; else ptb2[g0]=b2; if(d1<0) ptb2[g1]=b3; else ptb1[g1]=b3; }
								else              { if(d0<0) ptb1[g0]=b3; else ptb2[g0]=b3; if(d1<0) ptb2[g1]=b2; else ptb1[g1]=b2; }
								                    if(d2<0) ptb1[g2]= 0; else ptb2[g2]= 0; if(d3<0) ptb2[g3]= 0; else ptb1[g3]= 0;
								s=0; r=0;
								ccd++;
								break;
							}
							continue;
						}
						for(b2=1;b2;) { if((g2=indx[i2=cend[n]+(int)((cend[n+1]-cend[n])*drand48())])<0) b2=ptb1[g2*=-1]; else b2=ptb2[g2]; }
						for(       ;i2>cend[n  ];i2--) { if((g2=indx[i2])<0) { if(ptb2[g2*=-1]) break; } else if(ptb1[g2]) break; }
						for(i3=i2+1;i3<cend[n+1];i3++) { if((g3=indx[i3])<0) { if(ptb1[g3*=-1]) break; } else if(ptb2[g3]) break; }
						while(i1-i0!=i3-i2) {
							if(i1-i0<i3-i2) { 
								k=i0; i0=i2; i2=k;
								k=i1; i1=i3; i3=k;
							}
							if(i3==cend[n+1] || drand48()<0.5)
							     for(i2-=1;i2>cend[n  ];i2--) { if((g2=indx[i2])<0) { if(ptb2[g2*=-1]) break; } else if(ptb1[g2]) break; }
							else for(i3+=1;i3<cend[n+1];i3++) { if((g3=indx[i3])<0) { if(ptb1[g3*=-1]) break; } else if(ptb2[g3]) break; }
						}
						if((i0<=i2 && i2<=i1) || (i2<=i1 && i1<=i3))  continue;
						for(k=i0,m=(p=drand48())<0.50?i2:i3-1;k<i1;k++,m=p<0.5?m+1:m-1) {
							if((g0=indx[k  ])<0) { b0=ptb1[g0*=-1]; d0=-1; } else { b0=ptb2[g0]; d0=1; }
							if((g2=indx[m  ])<0) { b2=ptb1[g2*=-1]; d2=-1; } else { b2=ptb2[g2]; d2=1; } if(b0*b2 || !(b0+b2)) continue;
							if((g1=indx[k+1])<0) { b1=ptb2[g1*=-1]; d1=-1; } else { b1=ptb1[g1]; d1=1; }
							if((g3=indx[m+1])<0) { b3=ptb2[g3*=-1]; d3=-1; } else { b3=ptb1[g3]; d3=1; }
							if(b2) { 
								if(drand48()<0.5) { if(d0<0) ptb1[g0]=b2; else ptb2[g0]=b2; if(d1<0) ptb2[g1]=b3; else ptb1[g1]=b3; }
								else              { if(d0<0) ptb1[g0]=b3; else ptb2[g0]=b3; if(d1<0) ptb2[g1]=b2; else ptb1[g1]=b2; }
								                    if(d2<0) ptb1[g2]= 0; else ptb2[g2]= 0; if(d3<0) ptb2[g3]= 0; else ptb1[g3]= 0;
							}
							else {
								if(drand48()<0.5) { if(d2<0) ptb1[g2]=b0; else ptb2[g2]=b0; if(d3<0) ptb2[g3]=b1; else ptb1[g3]=b1; }
								else              { if(d2<0) ptb1[g2]=b1; else ptb2[g2]=b1; if(d3<0) ptb2[g3]=b0; else ptb1[g3]=b0; }
								                    if(d0<0) ptb1[g0]= 0; else ptb2[g0]= 0; if(d1<0) ptb2[g1]= 0; else ptb1[g1] =0;
							}
							s=0; r=0;
							ccd++;
						}
					}
					//migrate hot-spots
					for(d=0;d<hd;) {
						for(b1=0;!b1        ;) { if((g1=indx[i1=(int)((ng-1)*drand48())+1])<0) { b1=ptb2[g1*=-1]; d1=-1; } else { b1=ptb1[g1]; d1=1; } }
						for(b2=0;!b2||i1==i2;) { if((g2=indx[i2=(int)((ng-1)*drand48())+1])<0) { b2=ptb1[g2*=-1]; d2=-1; } else { b2=ptb2[g2]; d2=1; } }
						if((g0=indx[i1-1])<0) { g0*=-1; b0=ptb1[g0]; d0=-1; } else { b0=ptb2[g0]; d0=1; }
						if((g3=indx[i2+1])<0) { g3*=-1; b3=ptb2[g3]; d3=-1; } else { b3=ptb1[g3]; d3=1; }
						for(m=0,k=(int)(24*drand48());m<4;m++) {
							if     (migord[k][m]==1) { if(b0!=b2) { if(d0<0)ptb1[g0]=b2; else ptb2[g0]=b2; if(d2<0)ptb1[g2]=b0; else ptb2[g2]=b0; break; } }
							else if(migord[k][m]==2) { if(b0!=b3) { if(d0<0)ptb1[g0]=b3; else ptb2[g0]=b3; if(d3<0)ptb2[g3]=b0; else ptb1[g3]=b0; break; } }
							else if(migord[k][m]==3) { if(b1!=b2) { if(d1<0)ptb2[g1]=b2; else ptb1[g1]=b2; if(d2<0)ptb1[g2]=b1; else ptb2[g2]=b1; break; } }
							else if(migord[k][m]==4) { if(b1!=b3) { if(d1<0)ptb2[g1]=b3; else ptb1[g1]=b3; if(d3<0)ptb2[g3]=b1; else ptb1[g3]=b1; break; } }
						}
						if(m==4) continue;
						d++;
					}
					v++;
					break;
				}
			}
			for(m=tree[b][1],k=0;k<ng;k++) { 
				allix[m][k]=indx[k];
				allb1[m][k]=ptb1[k];
				allb2[m][k]=ptb2[k];
			}
		}
		//calculate statistics
		ur=0;
		for(j=0;j<=mc;j++) clds[j]=0;
		for(j=0;j<=mh;j++) hots[j]=0;
		for(j=0;j<=mp;j++) ngps[j]=0;
		for(j=0;j<ne;j+=2) {
			for(n=m=0,k=cend[j]+1;k<=cend[j+1];k++,m++) {
				if(brk1[k]) {
					hots[brk2[k-1]>mh?mh:brk2[k-1]]++;
					hots[brk1[k  ]>mh?mh:brk1[k  ]]++;
					if(m) {
						for(f=0;f<nf;f++) {
							for(b=0,c=0,r=0,x=k-m+1;x<k;x++) {
								if(!allb1[f][x]) {
									if(r==0) { b++; r=1; }
									c++;
								}
								else r=0;
							}
							if     (m>=cflr) { tclr+=c; nblr+=b; }
							else if(m>=cfmr) { tcmr+=c; nbmr+=b; }
							else if(m>=cfsr) { tcsr+=c; nbsr+=b; }
							if(b) oluc++;
						}
						for(c=0,x=k-m+1;x<k;x++) {
							for(f=0;f<nf;f++) if(allb1[f][x]) break;
							if(f==nf) c++;
						}
						if     (m>=cflr) { cclr+=c; sclr+=m-1; nslr++; }
						else if(m>=cfmr) { ccmr+=c; scmr+=m-1; nsmr++; }
						else if(m>=cfsr) { ccsr+=c; scsr+=m-1; nssr++; }
						nsol++;
						hots[0]+=(m-1)*2;
						m=m>mc?mc:m;
						abri[m]+=n+brk2[k-1];
						clds[m]++;
						m=0;
					}
					clds[0]+=(brk2[k-1]+brk1[k]-2)*0.5;
					n=brk1[k];
				}
			}
			if(--m) {
				for(f=0;f<nf;f++) {
					for(b=0,c=0,r=0,x=k-m+1;x<k;x++) {
						if(!allb1[f][x]) {
							if(r==0) { b++; r=1; }
							c++;
						}
						else r=0;
					}
					if     (m>=cflr) { tclr+=c; nblr+=b; }
					else if(m>=cfmr) { tcmr+=c; nbmr+=b; }
					else if(m>=cfsr) { tcsr+=c; nbsr+=b; }
					if(b) oluc++;
				}
				for(c=0,x=k-m+1;x<k;x++) {
					for(f=0;f<nf;f++) if(allb1[f][x]) break;
					if(f==nf) c++;
				}
				if     (m>=cflr) { cclr+=c; sclr+=m-1; nslr++; }
				else if(m>=cfmr) { ccmr+=c; scmr+=m-1; nsmr++; }
				else if(m>=cfsr) { ccsr+=c; scsr+=m-1; nssr++; }
				nsol++;
				hots[0]+=(m-1)*2;
				m=m>mc?mc:m;
				abri[m]+=n;
				clds[m]++;
			}
		}
		for(j=0;j<rr;j++) {
			for(k=0;k<4;k++) {
				n=rr2g[j][k];
				if(n<0) { if(brk1[-n]!=1) break; }
				else    { if(brk2[ n]!=1) break; }
			}
			if(k==4) ur++;
		}
		for(j=0;j<nf;j++) { 
			for(k=1;k<ng;k++) {
				g1=allix[j][k-1];
				g2=allix[j][k  ];
				if(abs(g1)>abs(g2)){x=-g1;g1=-g2;g2=x;}
				u1=g1<0?-g1:g1;
				u2=g2<0?-g2:g2;
				if(g1<0) { for(m=0;m<pct1[u1];m++) if(prs1[u1][m]==-g2) break; if(m==pct1[u1]) prs1[u1][pct1[u1]++]=-g2; }
				else     { for(m=0;m<pct2[u1];m++) if(prs2[u1][m]== g2) break; if(m==pct2[u1]) prs2[u1][pct2[u1]++]= g2; }
				if(g2>0) { for(m=0;m<pct1[u2];m++) if(prs1[u2][m]== g1) break; if(m==pct1[u2]) prs1[u2][pct1[u2]++]= g1; }
				else     { for(m=0;m<pct2[u2];m++) if(prs2[u2][m]==-g1) break; if(m==pct2[u2]) prs2[u2][pct2[u2]++]=-g1; }
			}
		}
		for(j=0;j<ng;j++) {
			ngps[pct1[j]>mp?mp:pct1[j]]++;
			ngps[pct2[j]>mp?mp:pct2[j]]++;
		}
		ngps[1]-=ne-2;
		if(E>2) {
			for(j=0;j<=mc;j++) printf("%2i\t%e\n",j,clds[j]/ns); printf("\n");
			for(j=0;j<=mh;j++) printf("%2i\t%e\n",j,hots[j]/ns); printf("\n1\t%e\n2\t%e\n\n",((double)ur)/ns,ni-((double)ur)/ns);
			for(j=1;j<=mp;j++) printf(" %i\t%e\n",j,ngps[j]/ns); printf("\n");
			for(k=0;k< ng;k++) {
				if(allix[0][k]<0) indx[-allix[0][k]]=-k;
				else              indx[ allix[0][k]]= k;
			}
			for(j=0;j<nf;j++) {
				for(k=1;k<ng-1;k++) {
					x=allix[j][k]<0?indx[-allix[j][k]]:indx[allix[j][k]];
					printf("%i ",(x*allix[j][k]<0?-1:1)*(x<0?-x:x));
				}
				printf("\n");
			}
			printf("\n");
		}
		for(j=0;j<=mc;j++) cldt[j]+=clds[j];
		for(j=0;j<=mh;j++) hott[j]+=hots[j];
		for(j=0;j<=mp;j++) ngpt[j]+=ngps[j]; 
		tur+=ur;
		if(++i%1==0 && E) fprintf(stderr,"\rDone: %.0f%% (%i)",100.0*i/ns,i);
	}
	if(E) fprintf(stderr,"\n\n");
	for(cr=i=0;i<oc;i++) if( obcd[i]) cr+=obcd[i]-1;
	for(i=0;i<=mc;i++) printf("%2i\t%e\t%e\n",i,cldt[i]/ns,abri[i]/cldt[i]/2); printf("\n");
	for(i=0;i<=mh;i++) printf(    "%2i\t%e\n",i,hott[i]/ns); printf("\n1\t%e\n2\t%e\n\n",((double)tur)/ns,ni-((double)tur)/ns);
	for(i=1;i<=mp;i++) printf(     "%i\t%e\n",i,ngpt[i]/ns);
	if(R) printf("\n%.2f/%.2f  %.2f/%.2f  %.2f/%.2f  %.2f-%.2f/%.2f  %.2f-%.2f/%.2f  %.2f-%.2f/%.2f  %.2f/%.0f  %.3f/%.3f\n",
		(cclr+ccmr+ccsr)/cr/ns,(tclr+tcmr+tcsr)/nf/cr/ns,nruc?msru/nruc:0,nrnu?msrn/nrnu:0,nplr/ns,nslr/ns,sclr?cclr/sclr:0,sclr?tclr/nf/sclr:0,nslr?nblr/nf/nslr:0,ccmr/scmr,tcmr/nf/scmr,nbmr/nf/nsmr,ccsr/scsr,tcsr/nf/scsr,nbsr/nf/nssr,oluc/nf/nsol,nsol/ns,rw2h/ni/ns,rw1h/ni/ns);
	else  printf("\n%i %.0f %.0f %.0f %.0f %.0f %.0f %.0f %.0f %.0f %.0f %.0f %.0f %.0f %.0f %.0f %.0f %.0f %.0f %.0f %.0f %.0f %.0f %.0f %.0f %0.f %.0f %i %i\n",
		cr,cclr+ccmr+ccsr,(tclr+tcmr+tcsr)/nf,msru,nruc,msrn,nrnu,nplr,cclr,tclr/nf,sclr,nblr/nf,nslr,ccmr,tcmr/nf,scmr,nbmr/nf,nsmr,ccsr,tcsr/nf,scsr,nbsr/nf,nssr,oluc/nf,nsol,rw2h,rw1h,ni,ns);
	return 0;
}

void dqsort(int* a, double* v, int l, int p) {
	int t, i=l, j=p;
	double x=v[a[(l+p)/2]];
	while(i<j) {
		while(v[a[i]]>x) i++;
		while(x>v[a[j]]) j--;
		if(i<=j) { t=a[i]; a[i++]=a[j]; a[j--]=t; }
	}
	if(l<j) dqsort(a,v,l,j);
	if(i<p) dqsort(a,v,i,p);
}

void ddqs(int* v, int l, int p) {
	int i=l, j=p, t, x=v[(l+p)/2];
	while(i<j) {
		while(v[i]>x) i++;
		while(x>v[j]) j--;
		if(i<=j) { t=v[i]; v[i++]=v[j]; v[j--]=t; }
	}
	if(l<j) ddqs(v,l,j);
	if(i<p) ddqs(v,i,p);
}
