#!/usr/bin/perl -w

if(@ARGV<5){ die "Usage: $0 files-x2 Total1 Total2 BLOCK SKIP"}

$B=$ARGV[$#ARGV-1];
foreach(split /\s+/,$ARGV[$#ARGV]) { $skip{$_}=1 }

for($I=0;$I<@ARGV;$I+=2) {
	if(!-e $ARGV[$I]){last}
	open(I1,$ARGV[$I+0])||die;
	open(I2,$ARGV[$I+1])||die;
	for($r=0,$i=1;$i<$B;$r=0) { while(<I1>){chomp;if($_ eq ""){$i++;last}$r=1} if(!$r){die} }
	for($r=0,$i=1;$i<$B;$r=0) { while(<I2>){chomp;if($_ eq ""){$i++;last}$r=1} if(!$r){die} }
	while(<I1>) {
		chomp;
		if($_ eq ""){last}
		$_=~s/^\s+//;
		($x,$v)=split /\s+/,$_;
		if(exists $skip{$x}){next}
		if(!exists $x2i{$x}){$x2i{$x}=@x1}
		$i=$x2i{$x};
		$x1[$i]=$x;
		$v1[$i]+=$v;
	}
	while(<I2>) {
		chomp;
		if($_ eq ""){last}
		 $_=~s/^\s+//;
		($x,$v)=split /\s+/,$_;
		if(exists $skip{$x}){next}
		if(!exists $x2i{$x}){$x2i{$x}=@x2}
		$i=$x2i{$x};
		$x2[$i]=$x;
		$v2[$i]+=$v;
	}
}
for($i=0;$i<@x1 && $i<@x2;$i++) { if($x1[$i]!=$x2[$i]){die} }
if($i<@x2) {  for(;$i<@x2;$i++) { push @x1,$x2[$i]; push @v1,0 } }
if($i<@x1) {  for(;$i<@x1;$i++) { push @x2,$x1[$i]; push @v2,0 } }

foreach(@v1){$_*=$ARGV[$#ARGV-3]}
foreach(@v2){$_*=$ARGV[$#ARGV-2]}
$v1=0; foreach(@v1){$v1+=$_}
$v2=0; foreach(@v2){$v2+=$_}

if($v1<=$v2) { $n1=$v1; @n1=@v1; $n2=$v2; @n2=@v2; }
else         { $n2=$v1; @n2=@v1; $n1=$v2; @n1=@v2; }
foreach(@n2){$_*=$n1/$n2}
for($i=$#n2;$i>0;$i--) {
	if($n1[$i]<5 || $n2[$i]<5) {
		$n1[$i-1]+=$n1[$i]; $x1[$i-1].=",$x1[$i]";
		$n2[$i-1]+=$n2[$i]; $x2[$i-1].=",$x2[$i]";
		for($j=$i+1;$j<@n2;$j++) {
			$n1[$j-1]=$n1[$j]; $x1[$j-1]=$x1[$j];
			$n2[$j-1]=$n2[$j]; $x2[$j-1]=$x2[$j];
		}
		$#n2--;
		$#n1--;
	}
}

for($ctv=$i=0;$i<@n2;$i++) { $ctv+=($n1[$i]-$n2[$i])*($n1[$i]-$n2[$i])/$n2[$i] }
for($gtv=$i=0;$i<@n2;$i++) { $gtv+=2*$n1[$i]*log($n1[$i]/$n2[$i]) }
$ctpv=&ctpv($ctv,$dof=$#n1);
$gtpv=&gtpv($gtv,$dof,$n1 );

$n1=$v1; @n1=@v1; for($i=1;$i<@n1;$i++) { $n1[$i]+=$n1[$i-1] } foreach(@n1) { $_/=$n1 }
$n2=$v2; @n2=@v2; for($i=1;$i<@n2;$i++) { $n2[$i]+=$n2[$i-1] } foreach(@n2) { $_/=$n2 }
for($ksd=$i=0;$i<@n1;$i++) { if(($d=abs($n1[$i]-$n2[$i]))>$ksd){$ksd=$d} }
for($d12=$i=0;$i<@n1;$i++) { if(($d=    $n1[$i]-$n2[$i] )>$d12){$d12=$d} }
for($d21=$i=0;$i<@n1;$i++) { if(($d=    $n2[$i]-$n1[$i] )>$d21){$d21=$d} }
$kpd=$d12+$d21;
$kspv=kspv($ksd,$n1,$n2);
$kppv=kppv($kpd,$n1,$n2);

print sprintf("$ARGV[1]\tChi = %1.2e(%.0f,%i)\tGad = %1.4e(%.0f,%i)\tKS = %1.2e(%.3f)\tKP = %1.2e(%.3f)\n",
		$ctpv,$ctv,$dof,$gtpv,$gtv,$dof,$kspv,$ksd,$kppv,$kpd);

sub kspv {
	my $p=0; my $j; my $t; my $s=2;
	my $ne=sqrt($_[1]*$_[2]/($_[1]+$_[2]));
	my $z=$_[0]*($ne+0.12+0.11/$ne);
	my $u=-2*$z**2;
	if($z==0) { return 1 }
	for($j=1;$t=$s*exp($u*$j**2);$j++,$s*=-1){$p+=$t}
	return $p; 
}

sub kppv {
	my $p=0; my $j; my $t; my $k;
	my $ne=sqrt($_[1]*$_[2]/($_[1]+$_[2]));
	my $z=$_[0]*($ne+0.155+0.24/$ne);
	if($z==0) { return 1 }
	for($z*=2*$z,$j=1;;$j++){
		$k=$z*$j**2;
		$t=2*(2*$k-1)*exp(-$k);
		if($t==0){last}
		$p+=$t;
	}
	return $p
}

sub gtpv {
	return &ctpv($_[0],$_[1])*(1+($_[1]+2)/(6*$_[2]));
}

sub ctpv {
	my $x=$_[0]/2; my $k=$_[1]/2;
	if($x<0 || $k<=0){die}
	if($x==0){ return 1 }
	if($k==0){ return 0 }
	if($x<$k+1) {
		my $s=1./$k; my $d=$s;
		for(my $j=$k+1,$n=1;$d=$d*$x/$j;$n++,$j++) { $s=$s+$d }
		return 1-$s*exp(-$x+$k*log($x)-&gammln($k));
	}
	else {
		my $M=1.e-30;  my $c=1/$M; my $a;  
		my $b=$x+1-$k; my $d=1/$b; my $h=$d;
		for(my $j=1;;$j++,$h*=$t) {
			$a=-$j*($j-$k); $b+=2;
			if(abs($d=$a*$d+$b)<$M) { $d=$M }
			if(abs($c=$b+$a/$c)<$M) { $c=$M }
			$d=1./$d;
			if(($t=$d*$c)==1){last}
		}
		return exp(-$x+$k*log($x)-&gammln($k))*$h;
	}
}

sub gammln {
	my $x=$_[0]; my $s=1; my $t=($x-0.5)*log($x+4.5)-$x-4.5;
	my @cof=(76.18009173,-86.50532033,24.01409822,-1.231739516,0.120858003e-2,-0.536382e-5);
	for(my $j=0;$j<6;$j++,$x++) { $s+=$cof[$j]/$x }
	return $t+log(2.50662827465*$s);
}

