#!/usr/bin/perl -w

# written by John Edwards
# jedwards@dom.wustl.edu
# see README.txt for further information

use strict;
use FileHandle;

my $usage = "USAGE: $0 cmapFile inFile outDir libDescriptor[M,R]\n";

die $usage unless @ARGV == 4;

my $cmapFile = shift; #cmap file used for corona mate pair mapping pipeline
my $in = shift; # mates file
my $outDir = shift;
my $libDesc = shift; # M for McrBC, R for RE
my $tagLength = 25;

open(CMAP, $cmapFile) or die "Can't open cmapfile $cmapFile: $!\n$usage";
open(IN, $in) or die "Can't open $in: $!\n$usage";

#my $chr = 'unknown';
my $counter = 0;
my $counterSize = 100000;
my $counterNum = 0;

# check if output exists before overwriting
if (-e "$outDir/chr17.bed") { die "Outputs already exist!!!\n"; }

# set up output files for writing
my (%fileHandleHash, %chrDecode);
while(<CMAP>) {
	my ($chrNum, $chr, undef )  = split;
	next unless $chr;
	$chr = "chr" . $chr;
	$chrDecode{ $chrNum } = $chr;

	my $fh = new FileHandle;
	unless ( $fh->open(">>$outDir/$chr.bed") ) {
		die "Can't open $outDir/$chr.bed: $!\n";
	}
	$fileHandleHash{$chrNum} = $fh;
	#print $fh "browser position $chr\n";
    #print $fh "track name=\"$chr $libDesc\" description=\"paired data $libDesc\" color=$color\n";
} 

# start parsing
my (@removeList, %pairList);
while( <IN> ) {
	$counter++;
	if ( $counter % 100000  == 0) { print STDERR "Now on line: $counter\n"; }
	next if (/^#/);
	my ($id, undef, undef, undef, undef, undef, $chrNum1, $chrNum2, $coord1, $coord2, $matchType, undef) = split;
	next unless $matchType eq 'AAA'; # only take proper matches
	my $chr;
	if ( $chrDecode{ $chrNum1 } ) {
		$chr = $chrDecode{ $chrNum1 };
	} else {
		print STDERR "Can't find chr encoding for $chrNum1, ID: $id, skipping...\n";
		next;
	}
	
	my ($start, $end, $strand);
	if ($coord1 > 0) {
		$strand = "+";
		$start = $coord2;
		$end = $coord1 + $tagLength;
	} else {
		$strand = "-";
		$start = abs($coord1) - $tagLength;
		$end = abs($coord2);
	}

	my $fh = $fileHandleHash{$chrNum1};

	print $fh "$chr\t$start\t$end\t$id\t1\t$strand\n";
}


