#!/usr/bin/perl -w

# written by John Edwards
# jedwards@dom.wustl.edu
# see README.txt for further information


use strict;

my $usage = "USAGE: $0 <cpgFile> <outFile>\n";

die $usage unless @ARGV == 2;

my $cpgFile = shift;
my $outFile = shift;

my $printCounterValue = 200000;

my (%siteHistogram, %labelHistogram);
my $totalCpGCount = 0;

open( CPG, $cpgFile ) or die "Can't opendir $cpgFile: $!\n$usage\n";
open(OUT, ">$outFile") or die "Can't open $outFile:$!\n$usage\n";

while(<CPG>) {
	my ( 	$chr, $cpgID, $mcrbcInteriorValue, 
			$mcrbcEndInsideValue, $mcrbcEndOutsideValue, $reInteriorValue, $reEndValue, undef) = split;

	unless (defined $mcrbcInteriorValue and defined $mcrbcEndInsideValue and defined $mcrbcEndOutsideValue and defined $reInteriorValue and defined $reEndValue) {
		print STDERR "Problem with line : $_, skipping\n";
		next;
	}

   	my ($methScore, $unmethScore, $coverage) = &findMethylationStatus(   $mcrbcInteriorValue, $mcrbcEndInsideValue, $mcrbcEndOutsideValue, $reInteriorValue, $reEndValue );

	$totalCpGCount++;

	if ($totalCpGCount % $printCounterValue == 0) {
		print STDERR "\tnow on line $totalCpGCount\n";
	}

	print OUT "$chr\t$cpgID\t$methScore\t$unmethScore\t$coverage\n";
}
close CPG;

sub findMethylationStatus {

    my $mcrbcInteriorValue = shift;
    my $mcrbcEndInsideValue = shift;
    my $mcrbcEndOutsideValue = shift;
    my $reInteriorValue = shift;
    my $reEndValue = shift;

    my $totalValue = $mcrbcInteriorValue + $reInteriorValue + $reEndValue;
    my $methValue = $reInteriorValue;
    my $unmethValue = $mcrbcInteriorValue + $reEndValue;

    my $methScore =0;                                      
    my $unmethScore =0;

	if ( $totalValue > 0 ) {
    	$methScore = $methValue / $totalValue;
    	$unmethScore = $unmethValue / $totalValue;
    }

    return $methScore,$unmethScore,$totalValue;
}

