/*----------------------------------------------------------------*
 *
 * File : validation.h
 * Author : NTM
 * Created : 15/09/04
 *
 *
 * Copyright (C) Nicolas Thierry-Mieg, 2006.
 *
 *
 * This file is part of InterPool, written by 
 * Nicolas Thierry-Mieg (CNRS, France) Nicolas.Thierry-Mieg@imag.fr
 *
 * InterPool is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InterPool is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with InterPool; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *-----------------------------------------------------------------*/

#ifndef _validation_h_
#define _validation_h_

#include "jobs.h" /* definition of JobIdentSim datatype */



/*! 
  \file validation.h
  \brief validation launches a set of simulations using 2
  (different) solvexp methods, and compares the obtained signatures
  instead of outputing the simulation results.
  Since the signatures should always be identical, this can reveal
  bugs.
*/



/*!
  \brief Using 2 (different) solvexp methods, perform a 
  batch of simulations as specified in thisJob, and compare the
  obtained nearest coherent signatures instead of outputing the 
  simm results.
  method1 and method2 choose the solvexp methods you want to compare.
  Current valid values are: 
    - 1: use solvexpNaive
    - 2: use solvexpClosure (with method==1, ie findBestClosuresSim with Rec)
    - 3: use solvexpClosure (with method==2, ie findBestClosuresSim with RecSubstracted)
    - 4: use solvexpClosure (with method==3, ie findBestClosuresReal with Rec)
    - 5: use solvexpClosure (with method==4, ie findBestClosuresReal with RecSubstracted)
*/
void validation(JobIdentSim *thisJob, int method1, int method2) ;


#endif

