/*-------------------------------------------------------------*
 *
 * File : types.h
 * Author : NTM
 * Created : 02/07/04
 *
 *
 * Copyright (C) Nicolas Thierry-Mieg, 2006.
 *
 *
 * This file is part of InterPool, written by 
 * Nicolas Thierry-Mieg (CNRS, France) Nicolas.Thierry-Mieg@imag.fr
 *
 * InterPool is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InterPool is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with InterPool; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *--------------------------------------------------------------*/

#ifndef _types_h_
#define _types_h_

#include <limits.h> /* ULONG_MAX etc... */



/*!
  \file types.h
  \brief Define the various types used throughout the code.
*/


/* MOT is the primitive datatype used to store the bits of 
   data in vectors to represent variables'values, pools, closures...
   For best performance, a MOT should be 32 bits long on a 32-bit 
   machine, 64 on a 64-bit machine, etc...
   unsigned long int is a good candidate on most systems, but
   you can change this if necessary (eg to unsigned long long int if
   you have a 64-bit machine but unsigned long is only 32-bits wide on
   your system).
   However, if you change MOT you MUST modify the calculation 
   of ARCH below!!
   In any case, it's probably a good idea to always add:
   if (ARCH != sizeof(MOT)*CHAR_BIT) {print error message and die}
   at the beginning of any main.
*/
#define MOT unsigned long int


/* calculate ARCH: this must be the number of bits in a MOT.
   We cannot use sizeof(MOT)*CHAR_BIT, because of masks.h 
   (where ARCH must be known at pre-processor time).
   Also, this could be dangerous because some bits may be 
   padded and unusable in MOT...? So, it seems the only
   way to make sure we have eg 32 accessible bits in an
   unsigned long, at the preprocessor step, is to test 
   if ULONG_MAX==4294967295UL.
*/
/* The following is assuming MOT== unsigned long int. If you change 
   the definition of MOT, you MUST change the following block!!
   For example if you change MOT to unsigned long long int,
   you should replace ULONG_MAX with ULLONG_MAX, and you could
   skip the first test since long long must be at least 64 bits wide.
*/
#if ULONG_MAX == 4294967295UL /* 32-bits */
#define ARCH 32
#elif ULONG_MAX == 18446744073709551615UL /* 64-bits */
#define ARCH 64
#else
#error "calculating ARCH, the size of MOT does not seem to be 32 or 64 bits!"
#endif


// define the type bool (lacking in C)
typedef enum {FALSE=0,TRUE=1} bool ;


#endif  /* #ifndef _types_h_ */
