/*----------------------------------------------------------------*
 *
 * File : solvexpClosure.h
 * Author : NTM
 * Created : 12/11/04
 *
 *
 * Copyright (C) Nicolas Thierry-Mieg, 2006.
 *
 *
 * This file is part of InterPool, written by 
 * Nicolas Thierry-Mieg (CNRS, France) Nicolas.Thierry-Mieg@imag.fr
 *
 * InterPool is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InterPool is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with InterPool; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *-----------------------------------------------------------------*/

#ifndef _solvexpClosure_h_
#define _solvexpClosure_h_

#include "types.h" /* MOT */
#include "signa.h" /* setOfSigs */


/*!
  \file solvexpClosure.h
  \brief This file holds a complete rewrite of the decoding methods
  written by gilles (held in solvexpNoisyClosureGilles.[ch] until 14/01/05,
  now removed from the codebase).
  I am rewriting everything from scratch because gilles' code is
  not clean enough to work on after all, and I want to modify the
  algorithms (they're fast, but not fast enough).

*/


/*!
  \brief Given an observed signature observedSig, find all nearest coherent
  interpretations and return them in a setOfSigs.
  This is the central interpool algorithm (paper in preparation).

  method==1 or 2 means do findBestClosuresSim, with Rec or RecSubstracted;<br>
  method==3 or 4 means do findBestClosuresReal (with Rec or RecSubstracted).
  maxDist: max distance to a coherent interpretation, when known
  (ie in Simm mode (method==1 or 2), where we know how many errors were 
  introduced); if method==3 or 4 this arg is ignored.
*/
setOfSigs solvexpClosure(MOT* tabpool, signature* observedSig, 
			 int maxDist, int method, int n) ;


#endif
