/*----------------------------------------------------------------*
 *
 * File : solveSigSimple.h
 * Author : NTM
 * Created : 30/09/03
 *
 *
 * Copyright (C) Nicolas Thierry-Mieg, 2006.
 *
 *
 * This file is part of InterPool, written by 
 * Nicolas Thierry-Mieg (CNRS, France) Nicolas.Thierry-Mieg@imag.fr
 *
 * InterPool is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InterPool is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with InterPool; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *-----------------------------------------------------------------*/

#ifndef _solveSigSimple_h_
#define _solveSigSimple_h_

#include "types.h" /* MOT */

/*!
  \file solveSigSimple.h
  \brief This file defines the solveSigSimple method, which builds a 
  deduced VV from a coherent interpretation

*/



/*!
  \brief Given an observation, return: 
  - the deduced VV if the canonical interpretation is 
    coherent (memory is allocated here)
  - NULL otherwise
*/
MOT* solveSigSimple(MOT* tabpool, signature* mySig, int n) ;


#endif
