/*----------------------------------------------------------------*
 *
 * File : simulObservation.h
 * Author : NTM
 * Created : 28/06/06
 *
 *
 * Copyright (C) Nicolas Thierry-Mieg, 2006.
 *
 *
 * This file is part of InterPool, written by 
 * Nicolas Thierry-Mieg (CNRS, France) Nicolas.Thierry-Mieg@imag.fr
 *
 * InterPool is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InterPool is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with InterPool; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *-----------------------------------------------------------------*/

#ifndef _simulObservation_h_
#define _simulObservation_h_


#include "types.h" /* MOT */
#include "signa.h" /* signature */

/* \file simulObservation.h
   \brief For performing simulations: build simulated observations
   for simulations and validations */


/*!
  \brief return the number of false STRONG (==POS, not WEAK).
*/
int falseStrong(int falsePos) ;

/*!
  \brief return the number of false WEAK.
*/
int falseWeak(int falsePos) ;

/*!
  \brief return the number of false FAINT.
*/
int falseFaint(int falseNeg) ;

/*!
  \brief return the number of false NONE (==NEG, not FAINT).
*/
int falseNone(int falseNeg) ;


/*!
  \brief Build and return a simulated observation, given:
  - the (simulated) positive vars;
  - the numbers of false positives and false negatives;
  - the fractions of observations that should be POS or WEAK
  among true positives on one hand and false positives on the
  other, and idem for NEG and FAINT wrt true and false negatives.
  These fractions are xx_FRAC defined in errorModel.h. <br>
  Of course falsePos must be smaller than the number of true 
  negative observations, and similarly falseNeg must be smaller 
  than the number of true positives.
  This is checked.
  The returned signature is not enriched (conflicts aren't tagged):
  it resembles as much as possible what we expect to obtain when
  performing an experiment.
*/
signature* buildObservation(MOT* tabpool, int n, int nbPools,
			    int* posvars, int falsePos, int falseNeg) ;


/*!
  \brief Return the distance between a simulated observation
  (as built by buildObservation) and the ideal noiseless 
  interpretation associated to posvars.
*/
int distToNoiseless(int falsePos, int falseNeg) ;



#endif 
