/*----------------------------------------------------------------*
 *
 * File : sigsToVVs.h
 * Author : NTM
 * Created : 01/04/05
 *
 *
 * Copyright (C) Nicolas Thierry-Mieg, 2006.
 *
 *
 * This file is part of InterPool, written by 
 * Nicolas Thierry-Mieg (CNRS, France) Nicolas.Thierry-Mieg@imag.fr
 *
 * InterPool is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InterPool is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with InterPool; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *-----------------------------------------------------------------*/

#ifndef _sigsToVVs_h_
#define _sigsToVVs_h_

#include "types.h" /* MOT */
#include "signa.h" /* setOfSigs */

/*!
  \file sigsToVVs.h
  \brief Builds the deduced VVs corresponding to a set of coherent sigs.
*/


/*!
  \brief Given a set of coherent sigs, build the deduced VV by merging the VVs
  corresponding to all the sigs (using a prudent merge, see mergeVVs).
  Also checks that every sig from the set is coherent.
  Returns the deduced VV (allocated here), or NULL (if coherentSigs 
  is empty).
*/
MOT* buildDeducedVV(setOfSigs coherentSigs, MOT* tabpool, int n) ;


#endif /* ifndef */
