/*---------------------------------------------------------*
 *
 * File : signaIO.h
 * Author : NTM
 * Created : 19/09/06
 *
 *
 * Copyright (C) Nicolas Thierry-Mieg, 2006.
 *
 *
 * This file is part of InterPool, written by 
 * Nicolas Thierry-Mieg (CNRS, France) Nicolas.Thierry-Mieg@imag.fr
 *
 * InterPool is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InterPool is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with InterPool; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *----------------------------------------------------------*/

#ifndef _signaIO_h_
#define _signaIO_h_

#include "signa.h" /* signature */


/*!
  \file signaIO.h
  \brief This file defines the IO functions for signature files.
  It results from a split of signa.[ch] (the XML stuff is somewhat
  heavy, and irrelevant for most work involving signatures).
*/


/*!
  \brief Read an observation from a file in version 2.0;
  build and return the corresponding signature.

  The format for the file (version 2.0) is described by an XML dtd,
  available in a DTD subdir somewhere... (hopefully!)
*/
signature* readSig(char* sigfile, int nbPools) ;


/*!
  \brief Read an observation from a file in the obsolete v1.x format;
  build and return the corresponding signature.

  Format for the file is:
  1. any empty line and any line starting with # is skipped (comments)
  2. each pool's signature value appears on a separate line (the acceptable
  values are those #defined in signa.h, but for an observed signature they
  should be restricted to SIG_NEG, SIG_FAINT, SIG_WEAK and SIG_POS). 
  They must appear in ascending  absolute pool number, ie using STD the 
  first k values are those of layer 0, the next k values are layer 1, etc...

  The total number of values must be == nbPools (this is checked).
*/
signature* readSigV1(char* sigfile, int nbPools) ;


/*!
  \brief Save a signature to a file. Format is identical 
  to readSig (currently v2.0).
*/
void writeSig(char* sigfile, const signature* mySig) ;


#endif
