/*----------------------------------------------------------------*
 *
 * File : poolInVector.h
 * Author : NTM
 * Created : 30/06/06
 *
 *
 * Copyright (C) Nicolas Thierry-Mieg, 2006.
 *
 *
 * This file is part of InterPool, written by 
 * Nicolas Thierry-Mieg (CNRS, France) Nicolas.Thierry-Mieg@imag.fr
 *
 * InterPool is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InterPool is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with InterPool; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *-----------------------------------------------------------------*/

#ifndef _poolInVector_h_
#define _poolInVector_h_

#include "types.h" /* MOT */

/*!
  \file poolInVector.h
  \brief This file holds low-level primitives for manipulating
  vectors of pools in the closure (closure.h), unitC (private 
  to unitClosures.h), and unitClosures datatypes.
  Currently, setPoolInVector is only used in unitClosures.c, and
  getPoolInVector only in closure.c. Yet these 2 functions are
  intimately linked, changing one means you must change the
  other (and in fact this is also true to some extent between
  the closure and unitClosures types).
*/


/*!
  \brief Return the number of MOTs used to store a negPools or 
  other xxxPools vector, in closure and unitC datatypes. 
  We use a single bit per pool.
  nbPools is the number of pools.
*/
int nbMotsPerPoolsVec(int nbPools) ;


/*!
  \brief Given a MOT* storing a posPools or other xxxPools vector, 
  set the bit coding for pool of absolute number absPoolNum to 
  value (0 or 1).
*/
void setPoolInVector(MOT* myVector, int absPoolNum, int value) ;


/*!
  \brief Given a MOT* storing a posPools or other xxxPools vector, 
  get and return the bit coding for pool absPoolNum.<br>
  Return value will be 0 or 1.
*/
int getPoolInVector(MOT* myVector, int absPoolNum) ;



#endif
