/*----------------------------------------------------------------*
 *
 * File : orderVectors.h
 * Author : NTM
 * Created : 01/07/06
 *
 *
 * Copyright (C) Nicolas Thierry-Mieg, 2006.
 *
 *
 * This file is part of InterPool, written by 
 * Nicolas Thierry-Mieg (CNRS, France) Nicolas.Thierry-Mieg@imag.fr
 *
 * InterPool is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InterPool is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with InterPool; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *-----------------------------------------------------------------*/

#ifndef _orderVectors_h_
#define _orderVectors_h_


#include "unitClosures.h" /* unitClosures */


/*!
  \file orderVectors.h
  \brief orderVector type and functions, to build vectors holding
  the unitnums of unit closures sorted by decreasing score or
  increasing negPoolsCost.
  This is for the RecSubstracted method in solvexpClosure.
*/


typedef struct
{
  int totalSize ; /*< total size of the unitNums vector 
		    (some can be unused, hence size) */
  int size ; /*!< number of unitnums present in vector 
	       (the rest of the vector should not be used) */
  int firstValid ; /*!< index in unitNums of first possibly valid unit */
  int* unitNums ;
} orderVector ;


/*!
  \brief return an orderVector of the indicated totalSize.
  unitNums is allocated but UNINITIALIZED, totalSize is 
  correctly set, and size and firstValid are 0.
  pre-condition: totalSize > 0.
*/
orderVector* buildVector(int totalSize) ;


/*!
  \brief free all memory relevant to myVector, including the 
  orderVector area itself.
*/
void freeVector(orderVector* myVector) ;


/*!
  \brief fill myVector up to min(newSize,myVector->totalSize), 
  so that it holds the unitnums in myUnits of the
  units sorted by decreasing score.
  Previous unitnums (up to myVector->size) are not touched,
  but the newly added unitnums will all be valid units.
  Return: TRUE if myVector was modified, FALSE otherwise (ie if
  there were no more valid units to add).
*/
bool fillByScore(orderVector* myVector, unitClosures* myUnits, int newSize) ;


/*!
  \brief fill myVector up to min(newSize,myVector->totalSize), 
  so that it holds the unitnums in myUnits of the
  units sorted by increasing negPoolsCost.
  Previous unitnums (up to myVector->size) are not touched,
  but the newly added unitnums will all be valid units.
  Return: TRUE if myVector was modified, FALSE otherwise (ie if
  there were no more valid units to add).
*/
bool fillByCost(orderVector* myVector, unitClosures* myUnits, int newSize) ;



#endif
