/*-----------------------------------------------------------*
 *
 * File : myrand.h
 * Author : NTM
 * Created : 30/06/04
 *
 *
 * Copyright (C) Nicolas Thierry-Mieg, 2006.
 *
 *
 * This file is part of InterPool, written by 
 * Nicolas Thierry-Mieg (CNRS, France) Nicolas.Thierry-Mieg@imag.fr
 *
 * InterPool is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InterPool is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with InterPool; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *------------------------------------------------------------*/

#ifndef _myrand_h_
#define _myrand_h_

/*!
  \file myrand.h
  \brief Interface for random number generator. 
   
  All randomness goes through this module 
*/


#define RANDGENNAME "random" /*!< (short) name of random generator, 
			          to use in the JobIdentSim structures.
				  maximum length is RANDGENLENGTH (defined in jobs.h).<br>
				  For now, use standard random (from stdlib.h) */


/*!
  \brief Returns a random int in {0,..,max-1}<br>
   if max is too big (eg larger than RAND_MAX when using rand 
   from stdlib.h), function exits noisily 
*/
int myrandom(int max);

/*! 
  \brief Plant random seed. 
*/
void plantSeed(unsigned int seed);

/*!
  \brief Choose a random seed.
*/
unsigned int chooseSeed(void);

#endif
