/*-----------------------------------------------------------*
 *
 * File : myrand.c
 * Author : NTM
 * Created : 30/06/04
 *
 *
 * Copyright (C) Nicolas Thierry-Mieg, 2006.
 *
 *
 * This file is part of InterPool, written by 
 * Nicolas Thierry-Mieg (CNRS, France) Nicolas.Thierry-Mieg@imag.fr
 *
 * InterPool is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InterPool is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with InterPool; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *------------------------------------------------------------*/


#include <stdlib.h> /* exit, random */
#include <stdio.h> /* printf and friends */
#include <time.h> /* for random seed generation */

#include "config.h" /* CONST_SEED */
#include "myrand.h"

/************************************************************************
 ******************* EXPORTED FUNCTIONS *********************************
 ************************************************************************/


////////////////////////////////////////////////////////////////////
// myrandom: returns a random int in {0,..,max-1}
// if max is too big (larger than RAND_MAX) function exits.
int myrandom(int max)
{
  int randval ;
  if (max > RAND_MAX)
    {
      fprintf(stderr, "in myrandom, max is too big\n") ;
      exit(1) ;
    }

  randval=(int)(((double)max*random())/(RAND_MAX+1.0));
  if (randval >= max)
    {
      /* on some systems (eg some SUNs) random returns numbers larger than RAND_MAX */
      fprintf(stderr, "in myrandom: generated value is too large!\n") ;
      fprintf(stderr, "This could be an issue with random() on your system, try using rand() instead.\n") ;
      fprintf(stderr, "See TROUBLESHOOTING in the README for details.\n") ;
      exit(1) ;
      /* TODO: instead of dying, I could just issue a warning to stderr 
	 (the first time in an execution only!), and use rand() in place of random() */
    }
  return randval ;
}


/* plantSeed: plant random seed */
void plantSeed(unsigned int seed)
{
  srandom(seed) ;
}

/* chooseSeed: choose a random seed */
unsigned int chooseSeed(void)
{
  unsigned int seed ;

#ifdef CONST_SEED
  /* for profiling/debugging: use a constant seed */
  // for comparing with eg xome AMD64 timing
  // seed = 1152288244 ;
  seed = 1159802404 ;

#else
  /* for sequential version: just use time */
  time_t currentTime = time(NULL) ;
  if (currentTime == (time_t)-1)
    {
      fprintf(stderr, "in chooseSeed: error calling time: time is unavailable on this system?\n") ;
      exit(1) ;
    }
  seed = (unsigned int)currentTime ;

#endif
  
  return seed ;
}


