/*-------------------------------------------------------------*
 *
 * File : masks.h
 * Author : NTM
 * Created : 28/06/06
 *
 *
 * Copyright (C) Nicolas Thierry-Mieg, 2006.
 *
 *
 * This file is part of InterPool, written by 
 * Nicolas Thierry-Mieg (CNRS, France) Nicolas.Thierry-Mieg@imag.fr
 *
 * InterPool is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InterPool is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with InterPool; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *--------------------------------------------------------------*/

#ifndef _masks_h_
#define _masks_h_

#include "types.h" /* ARCH */

/*! 
  \file masks.h
  \brief define MASKS used for some bitwise operations.
*/


/* MASKS: table of MOTs, each with all bits at 0 except one:
   mot at index i has bit number i (counting from the RIGHT!) at 1.
   MASKS should contain as many MOTs as there are bits in a MOT, plus 1:
   the last MOT of MASKS is 0x0 (ie, all bits are 0).
   This is used to search efficiently for the value of the ith bit of a MOT.
   NOTE: you shouldn't have to modify the following block: changing the 
   value of ARCH should suffice, unless you have a weird machine.
*/
#if ARCH == 16
#define MASKS { 0x1, 0x2, 0x4, 0x8, \
                0x10, 0x20, 0x40, 0x80, \
                0x100, 0x200, 0x400, 0x800, \
                0x1000, 0x2000, 0x4000, 0x8000, \
                0x0}
#elif ARCH == 32
#define MASKS { 0x1, 0x2, 0x4, 0x8, \
                0x10, 0x20, 0x40, 0x80, \
                0x100, 0x200, 0x400, 0x800, \
                0x1000, 0x2000, 0x4000, 0x8000, \
                0x10000, 0x20000, 0x40000, 0x80000, \
                0x100000, 0x200000, 0x400000, 0x800000, \
                0x1000000, 0x2000000, 0x4000000, 0x8000000, \
                0x10000000, 0x20000000, 0x40000000, 0x80000000, \
                0x0}
#elif ARCH == 64
#define MASKS { 0x1, 0x2, 0x4, 0x8, \
                0x10, 0x20, 0x40, 0x80, \
                0x100, 0x200, 0x400, 0x800, \
                0x1000, 0x2000, 0x4000, 0x8000, \
                0x10000, 0x20000, 0x40000, 0x80000, \
                0x100000, 0x200000, 0x400000, 0x800000, \
                0x1000000, 0x2000000, 0x4000000, 0x8000000, \
                0x10000000, 0x20000000, 0x40000000, 0x80000000, \
                0x100000000, 0x200000000, 0x400000000, 0x800000000, \
                0x1000000000, 0x2000000000, 0x4000000000, 0x8000000000, \
                0x10000000000, 0x20000000000, 0x40000000000, 0x80000000000, \
                0x100000000000, 0x200000000000, 0x400000000000, 0x800000000000, \
                0x1000000000000, 0x2000000000000, 0x4000000000000, 0x8000000000000, \
                0x10000000000000, 0x20000000000000, 0x40000000000000, 0x80000000000000, \
                0x100000000000000, 0x200000000000000, 0x400000000000000, 0x800000000000000, \
                0x1000000000000000, 0x2000000000000000, 0x4000000000000000, 0x8000000000000000, \
                0x0}
#else
#error "In masks.h: ARCH is not 16, 32 or 64! cannot compile!"
#endif /* ARCH==XX */



#endif /* ifndef _masks_h_ */

